/*
 * Decompiled with CFR 0.152.
 */
package io.proxsee.sdk.client.request;

import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonArrayRequest;
import io.proxsee.sdk.ProxSeeContext;
import io.proxsee.sdk.client.Callback;
import io.proxsee.sdk.client.request.AbstractProxSeeRequest;
import io.proxsee.sdk.client.request.RequestQueue;
import io.proxsee.sdk.client.response.MonitoringRegionsResponse;
import io.proxsee.sdk.entity.MonitoringRegion;
import io.proxsee.sdk.misc.Utils;
import java.util.Map;
import org.json.JSONArray;

public class MonitoringRegionsRequest
extends AbstractProxSeeRequest<MonitoringRegionsResponse> {
    private final String PATH = "/api/monitoringregions";
    private final ProxSeeContext proxSeeContext;

    public MonitoringRegionsRequest(ProxSeeContext context) {
        this.proxSeeContext = context;
    }

    @Override
    public void invoke(final Callback<MonitoringRegionsResponse> callback) {
        String url = this.proxSeeContext.getApiURL() + "/api/monitoringregions";
        JsonArrayRequest request = new JsonArrayRequest(0, url, (Response.Listener)new Response.Listener<JSONArray>(){

            public void onResponse(JSONArray response) {
                MonitoringRegion[] regions = (MonitoringRegion[])Utils.getGson().fromJson(response.toString(), MonitoringRegion[].class);
                callback.onSuccess(new MonitoringRegionsResponse(200, regions));
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                if (error.networkResponse != null) {
                    callback.onError(new MonitoringRegionsResponse(error.networkResponse.statusCode), error.getCause());
                } else {
                    callback.onError(null, error.getCause());
                }
            }
        }){

            public Map<String, String> getHeaders() {
                return MonitoringRegionsRequest.this.proxSeeContext.getHeaders();
            }
        };
        RequestQueue queue = RequestQueue.getInstance(this.proxSeeContext.getApplicationContext());
        queue.add((Request<?>)request);
    }
}

