/*
 * Decompiled with CFR 0.152.
 */
package io.proxsee.sdk.entity;

import android.text.TextUtils;
import io.proxsee.sdk.entity.Persistable;
import io.proxsee.sdk.entity.ProxSeeBeaconRealm;
import io.proxsee.sdk.model.CircularRegion;
import java.util.Arrays;

public class ProxSeeBeacon
implements Persistable<ProxSeeBeaconRealm>,
CircularRegion {
    private int major;
    private int minor;
    private String name;
    private double distance;
    private double lat;
    private double lng;
    private float radius;
    private boolean geofence;
    private String[] tags;
    private int rssi;

    public ProxSeeBeacon() {
    }

    public ProxSeeBeacon(ProxSeeBeacon beacon) {
        this.major = beacon.getMajor();
        this.minor = beacon.getMinor();
        this.name = beacon.getName();
        this.distance = beacon.getDistance();
        this.lat = beacon.getLat();
        this.lng = beacon.getLng();
        this.radius = beacon.getRadius();
        this.geofence = beacon.isGeofence();
        this.tags = beacon.getTags();
        this.rssi = beacon.getRssi();
    }

    public ProxSeeBeacon(int major, int minor) {
        this.setMajor(major);
        this.setMinor(minor);
        this.setTags(new String[0]);
        this.setName("");
    }

    public int getMajor() {
        return this.major;
    }

    void setMajor(int major) {
        this.major = major;
    }

    public int getMinor() {
        return this.minor;
    }

    void setMinor(int minor) {
        this.minor = minor;
    }

    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    double getDistance() {
        return this.distance;
    }

    void setDistance(double distance) {
        this.distance = distance;
    }

    @Override
    public double getLat() {
        return this.lat;
    }

    void setLat(double lat) {
        this.lat = lat;
    }

    @Override
    public double getLng() {
        return this.lng;
    }

    void setLng(double lng) {
        this.lng = lng;
    }

    @Override
    public float getRadius() {
        return this.radius;
    }

    public int getRssi() {
        return this.rssi;
    }

    public void setRssi(int rssi) {
        this.rssi = rssi;
    }

    void setRadius(float radius) {
        this.radius = radius;
    }

    public boolean isGeofence() {
        return this.geofence;
    }

    void setGeofence(boolean geofence) {
        this.geofence = geofence;
    }

    public String[] getTags() {
        return this.tags;
    }

    void setTags(String[] tags) {
        this.tags = tags;
    }

    public boolean isVirtual() {
        return this.isGeofence();
    }

    @Override
    public String getId() {
        return this.major + ":" + this.minor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProxSeeBeacon)) {
            return false;
        }
        ProxSeeBeacon that = (ProxSeeBeacon)o;
        if (this.major != that.major) {
            return false;
        }
        return this.minor == that.minor;
    }

    public int hashCode() {
        int result = this.major;
        result = 31 * result + this.minor;
        return result;
    }

    public String toString() {
        return "ProxSeeBeacon{name='" + this.name + '\'' + ", major=" + this.major + ", minor=" + this.minor + ", tags=" + Arrays.toString(this.tags) + '}';
    }

    @Override
    public ProxSeeBeaconRealm getEntity() {
        ProxSeeBeaconRealm proxSeeBeaconRealm = new ProxSeeBeaconRealm();
        proxSeeBeaconRealm.setId(this.getId());
        proxSeeBeaconRealm.setMajor(this.getMajor());
        proxSeeBeaconRealm.setMinor(this.getMinor());
        proxSeeBeaconRealm.setName(this.getName());
        proxSeeBeaconRealm.setLat(this.getLat());
        proxSeeBeaconRealm.setLng(this.getLng());
        proxSeeBeaconRealm.setRadius(this.getRadius());
        proxSeeBeaconRealm.setVirtual(this.isVirtual());
        proxSeeBeaconRealm.setTokenizedTags(this.tags == null ? null : TextUtils.join((CharSequence)"_=_", (Object[])this.tags));
        return proxSeeBeaconRealm;
    }
}

