/*
 * Decompiled with CFR 0.152.
 */
package io.proxsee.sdk.misc;

import android.content.Context;
import android.content.SharedPreferences;

public class Preference {
    private static final String TAG = Preference.class.getSimpleName();
    private static final String FILENAME = "proxseesdk_settings";
    private static final String KEY_CONFIG_HASH = "config_hash";
    private final SharedPreferences sharedPreferences;

    public Preference(Context context) {
        this.sharedPreferences = context.getSharedPreferences(FILENAME, 0);
    }

    public void setString(String key, String value) {
        SharedPreferences.Editor editor = this.sharedPreferences.edit();
        editor.putString(key, value);
        editor.commit();
    }

    public String getString(String key, String defaultValue) {
        return this.sharedPreferences.getString(key, defaultValue);
    }

    public void setBoolean(String key, Boolean value) {
        SharedPreferences.Editor editor = this.sharedPreferences.edit();
        editor.putBoolean(key, value.booleanValue());
        editor.commit();
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.sharedPreferences.getBoolean(key, defaultValue);
    }

    public void clear() {
        this.sharedPreferences.edit().clear();
    }
}

