/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import android.util.JsonReader;
import android.util.JsonToken;
import io.proxsee.sdk.entity.MonitoringRegionRealm;
import io.realm.Realm;
import io.realm.RealmFieldType;
import io.realm.RealmObject;
import io.realm.exceptions.RealmMigrationNeededException;
import io.realm.internal.ColumnInfo;
import io.realm.internal.ImplicitTransaction;
import io.realm.internal.RealmObjectProxy;
import io.realm.internal.Table;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class MonitoringRegionRealmRealmProxy
extends MonitoringRegionRealm
implements RealmObjectProxy {
    private final MonitoringRegionRealmColumnInfo columnInfo;
    private static final List<String> FIELD_NAMES;

    MonitoringRegionRealmRealmProxy(ColumnInfo columnInfo) {
        this.columnInfo = (MonitoringRegionRealmColumnInfo)columnInfo;
    }

    @Override
    public String getUuid() {
        this.realm.checkIfValid();
        return this.row.getString(this.columnInfo.uuidIndex);
    }

    @Override
    public void setUuid(String value) {
        this.realm.checkIfValid();
        if (value == null) {
            this.row.setNull(this.columnInfo.uuidIndex);
            return;
        }
        this.row.setString(this.columnInfo.uuidIndex, value);
    }

    @Override
    public int getMajor() {
        this.realm.checkIfValid();
        return (int)this.row.getLong(this.columnInfo.majorIndex);
    }

    @Override
    public void setMajor(int value) {
        this.realm.checkIfValid();
        this.row.setLong(this.columnInfo.majorIndex, (long)value);
    }

    public static Table initTable(ImplicitTransaction transaction) {
        if (!transaction.hasTable("class_MonitoringRegionRealm")) {
            Table table = transaction.getTable("class_MonitoringRegionRealm");
            table.addColumn(RealmFieldType.STRING, "uuid", true);
            table.addColumn(RealmFieldType.INTEGER, "major", false);
            table.addSearchIndex(table.getColumnIndex("major"));
            table.setPrimaryKey("major");
            return table;
        }
        return transaction.getTable("class_MonitoringRegionRealm");
    }

    public static MonitoringRegionRealmColumnInfo validateTable(ImplicitTransaction transaction) {
        if (transaction.hasTable("class_MonitoringRegionRealm")) {
            Table table = transaction.getTable("class_MonitoringRegionRealm");
            if (table.getColumnCount() != 2L) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Field count does not match - expected 2 but was " + table.getColumnCount());
            }
            HashMap<String, RealmFieldType> columnTypes = new HashMap<String, RealmFieldType>();
            for (long i = 0L; i < 2L; ++i) {
                columnTypes.put(table.getColumnName(i), table.getColumnType(i));
            }
            MonitoringRegionRealmColumnInfo columnInfo = new MonitoringRegionRealmColumnInfo(transaction.getPath(), table);
            if (!columnTypes.containsKey("uuid")) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Missing field 'uuid' in existing Realm file. Either remove field or migrate using io.realm.internal.Table.addColumn().");
            }
            if (columnTypes.get("uuid") != RealmFieldType.STRING) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Invalid type 'String' for field 'uuid' in existing Realm file.");
            }
            if (!table.isColumnNullable(columnInfo.uuidIndex)) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Field 'uuid' is required. Either set @Required to field 'uuid' or migrate using io.realm.internal.Table.convertColumnToNullable().");
            }
            if (!columnTypes.containsKey("major")) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Missing field 'major' in existing Realm file. Either remove field or migrate using io.realm.internal.Table.addColumn().");
            }
            if (columnTypes.get("major") != RealmFieldType.INTEGER) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Invalid type 'int' for field 'major' in existing Realm file.");
            }
            if (table.isColumnNullable(columnInfo.majorIndex)) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Field 'major' does support null values in the existing Realm file. Use corresponding boxed type for field 'major' or migrate using io.realm.internal.Table.convertColumnToNotNullable().");
            }
            if (table.getPrimaryKey() != table.getColumnIndex("major")) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Primary key not defined for field 'major' in existing Realm file. Add @PrimaryKey.");
            }
            if (!table.hasSearchIndex(table.getColumnIndex("major"))) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Index not defined for field 'major' in existing Realm file. Either set @Index or migrate using io.realm.internal.Table.removeSearchIndex().");
            }
            return columnInfo;
        }
        throw new RealmMigrationNeededException(transaction.getPath(), "The MonitoringRegionRealm class is missing from the schema for this Realm.");
    }

    public static String getTableName() {
        return "class_MonitoringRegionRealm";
    }

    public static List<String> getFieldNames() {
        return FIELD_NAMES;
    }

    public static MonitoringRegionRealm createOrUpdateUsingJsonObject(Realm realm, JSONObject json, boolean update) throws JSONException {
        MonitoringRegionRealm obj = null;
        if (update) {
            long rowIndex;
            Table table = realm.getTable(MonitoringRegionRealm.class);
            long pkColumnIndex = table.getPrimaryKey();
            if (!json.isNull("major") && (rowIndex = table.findFirstLong(pkColumnIndex, json.getLong("major"))) != -1L) {
                obj = new MonitoringRegionRealmRealmProxy(realm.schema.getColumnInfo(MonitoringRegionRealm.class));
                obj.realm = realm;
                obj.row = table.getUncheckedRow(rowIndex);
            }
        }
        if (obj == null) {
            obj = json.has("major") ? (json.isNull("major") ? (MonitoringRegionRealm)realm.createObject(MonitoringRegionRealm.class, null) : (MonitoringRegionRealm)realm.createObject(MonitoringRegionRealm.class, (Object)json.getInt("major"))) : (MonitoringRegionRealm)realm.createObject(MonitoringRegionRealm.class);
        }
        if (json.has("uuid")) {
            if (json.isNull("uuid")) {
                obj.setUuid(null);
            } else {
                obj.setUuid(json.getString("uuid"));
            }
        }
        if (json.has("major")) {
            if (json.isNull("major")) {
                throw new IllegalArgumentException("Trying to set non-nullable field major to null.");
            }
            obj.setMajor(json.getInt("major"));
        }
        return obj;
    }

    public static MonitoringRegionRealm createUsingJsonStream(Realm realm, JsonReader reader) throws IOException {
        MonitoringRegionRealm obj = (MonitoringRegionRealm)realm.createObject(MonitoringRegionRealm.class);
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("uuid")) {
                if (reader.peek() == JsonToken.NULL) {
                    reader.skipValue();
                    obj.setUuid(null);
                    continue;
                }
                obj.setUuid(reader.nextString());
                continue;
            }
            if (name.equals("major")) {
                if (reader.peek() == JsonToken.NULL) {
                    reader.skipValue();
                    throw new IllegalArgumentException("Trying to set non-nullable field major to null.");
                }
                obj.setMajor(reader.nextInt());
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return obj;
    }

    public static MonitoringRegionRealm copyOrUpdate(Realm realm, MonitoringRegionRealm object, boolean update, Map<RealmObject, RealmObjectProxy> cache) {
        if (object.realm != null && object.realm.getPath().equals(realm.getPath())) {
            return object;
        }
        MonitoringRegionRealmRealmProxy realmObject = null;
        boolean canUpdate = update;
        if (canUpdate) {
            long pkColumnIndex;
            Table table = realm.getTable(MonitoringRegionRealm.class);
            long rowIndex = table.findFirstLong(pkColumnIndex = table.getPrimaryKey(), (long)object.getMajor());
            if (rowIndex != -1L) {
                realmObject = new MonitoringRegionRealmRealmProxy(realm.schema.getColumnInfo(MonitoringRegionRealm.class));
                realmObject.realm = realm;
                realmObject.row = table.getUncheckedRow(rowIndex);
                cache.put(object, realmObject);
            } else {
                canUpdate = false;
            }
        }
        if (canUpdate) {
            return MonitoringRegionRealmRealmProxy.update(realm, realmObject, object, cache);
        }
        return MonitoringRegionRealmRealmProxy.copy(realm, object, update, cache);
    }

    public static MonitoringRegionRealm copy(Realm realm, MonitoringRegionRealm newObject, boolean update, Map<RealmObject, RealmObjectProxy> cache) {
        MonitoringRegionRealm realmObject = (MonitoringRegionRealm)realm.createObject(MonitoringRegionRealm.class, (Object)newObject.getMajor());
        cache.put(newObject, (RealmObjectProxy)realmObject);
        realmObject.setUuid(newObject.getUuid());
        realmObject.setMajor(newObject.getMajor());
        return realmObject;
    }

    public static MonitoringRegionRealm createDetachedCopy(MonitoringRegionRealm realmObject, int currentDepth, int maxDepth, Map<RealmObject, RealmObjectProxy.CacheData<RealmObject>> cache) {
        MonitoringRegionRealm standaloneObject;
        if (currentDepth > maxDepth || realmObject == null) {
            return null;
        }
        RealmObjectProxy.CacheData<RealmObject> cachedObject = cache.get(realmObject);
        if (cachedObject != null) {
            if (currentDepth >= cachedObject.minDepth) {
                return (MonitoringRegionRealm)cachedObject.object;
            }
            standaloneObject = (MonitoringRegionRealm)cachedObject.object;
            cachedObject.minDepth = currentDepth;
        } else {
            standaloneObject = new MonitoringRegionRealm();
            cache.put(realmObject, (RealmObjectProxy.CacheData<RealmObject>)new RealmObjectProxy.CacheData(currentDepth, (RealmObject)standaloneObject));
        }
        standaloneObject.setUuid(realmObject.getUuid());
        standaloneObject.setMajor(realmObject.getMajor());
        return standaloneObject;
    }

    static MonitoringRegionRealm update(Realm realm, MonitoringRegionRealm realmObject, MonitoringRegionRealm newObject, Map<RealmObject, RealmObjectProxy> cache) {
        realmObject.setUuid(newObject.getUuid());
        return realmObject;
    }

    public String toString() {
        if (!this.isValid()) {
            return "Invalid object";
        }
        StringBuilder stringBuilder = new StringBuilder("MonitoringRegionRealm = [");
        stringBuilder.append("{uuid:");
        stringBuilder.append(this.getUuid() != null ? this.getUuid() : "null");
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{major:");
        stringBuilder.append(this.getMajor());
        stringBuilder.append("}");
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public int hashCode() {
        String realmName = this.realm.getPath();
        String tableName = this.row.getTable().getName();
        long rowIndex = this.row.getIndex();
        int result = 17;
        result = 31 * result + (realmName != null ? realmName.hashCode() : 0);
        result = 31 * result + (tableName != null ? tableName.hashCode() : 0);
        result = 31 * result + (int)(rowIndex ^ rowIndex >>> 32);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MonitoringRegionRealmRealmProxy aMonitoringRegionRealm = (MonitoringRegionRealmRealmProxy)o;
        String path = this.realm.getPath();
        String otherPath = aMonitoringRegionRealm.realm.getPath();
        if (path != null ? !path.equals(otherPath) : otherPath != null) {
            return false;
        }
        String tableName = this.row.getTable().getName();
        String otherTableName = aMonitoringRegionRealm.row.getTable().getName();
        if (tableName != null ? !tableName.equals(otherTableName) : otherTableName != null) {
            return false;
        }
        return this.row.getIndex() == aMonitoringRegionRealm.row.getIndex();
    }

    static {
        ArrayList<String> fieldNames = new ArrayList<String>();
        fieldNames.add("uuid");
        fieldNames.add("major");
        FIELD_NAMES = Collections.unmodifiableList(fieldNames);
    }

    static final class MonitoringRegionRealmColumnInfo
    extends ColumnInfo {
        public final long uuidIndex;
        public final long majorIndex;

        MonitoringRegionRealmColumnInfo(String path, Table table) {
            HashMap<String, Long> indicesMap = new HashMap<String, Long>(2);
            this.uuidIndex = this.getValidColumnIndex(path, table, "MonitoringRegionRealm", "uuid");
            indicesMap.put("uuid", this.uuidIndex);
            this.majorIndex = this.getValidColumnIndex(path, table, "MonitoringRegionRealm", "major");
            indicesMap.put("major", this.majorIndex);
            this.setIndicesMap(indicesMap);
        }
    }
}

