/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import android.util.JsonReader;
import android.util.JsonToken;
import io.proxsee.sdk.entity.ProxSeeBeaconRealm;
import io.realm.Realm;
import io.realm.RealmFieldType;
import io.realm.RealmObject;
import io.realm.exceptions.RealmMigrationNeededException;
import io.realm.internal.ColumnInfo;
import io.realm.internal.ImplicitTransaction;
import io.realm.internal.RealmObjectProxy;
import io.realm.internal.Table;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class ProxSeeBeaconRealmRealmProxy
extends ProxSeeBeaconRealm
implements RealmObjectProxy {
    private final ProxSeeBeaconRealmColumnInfo columnInfo;
    private static final List<String> FIELD_NAMES;

    ProxSeeBeaconRealmRealmProxy(ColumnInfo columnInfo) {
        this.columnInfo = (ProxSeeBeaconRealmColumnInfo)columnInfo;
    }

    @Override
    public String getId() {
        this.realm.checkIfValid();
        return this.row.getString(this.columnInfo.idIndex);
    }

    @Override
    public void setId(String value) {
        this.realm.checkIfValid();
        if (value == null) {
            throw new IllegalArgumentException("Trying to set non-nullable field id to null.");
        }
        this.row.setString(this.columnInfo.idIndex, value);
    }

    @Override
    public int getMajor() {
        this.realm.checkIfValid();
        return (int)this.row.getLong(this.columnInfo.majorIndex);
    }

    @Override
    public void setMajor(int value) {
        this.realm.checkIfValid();
        this.row.setLong(this.columnInfo.majorIndex, (long)value);
    }

    @Override
    public int getMinor() {
        this.realm.checkIfValid();
        return (int)this.row.getLong(this.columnInfo.minorIndex);
    }

    @Override
    public void setMinor(int value) {
        this.realm.checkIfValid();
        this.row.setLong(this.columnInfo.minorIndex, (long)value);
    }

    @Override
    public String getName() {
        this.realm.checkIfValid();
        return this.row.getString(this.columnInfo.nameIndex);
    }

    @Override
    public void setName(String value) {
        this.realm.checkIfValid();
        if (value == null) {
            this.row.setNull(this.columnInfo.nameIndex);
            return;
        }
        this.row.setString(this.columnInfo.nameIndex, value);
    }

    @Override
    public String getTokenizedTags() {
        this.realm.checkIfValid();
        return this.row.getString(this.columnInfo.tokenizedTagsIndex);
    }

    @Override
    public void setTokenizedTags(String value) {
        this.realm.checkIfValid();
        if (value == null) {
            this.row.setNull(this.columnInfo.tokenizedTagsIndex);
            return;
        }
        this.row.setString(this.columnInfo.tokenizedTagsIndex, value);
    }

    @Override
    public boolean isVirtual() {
        this.realm.checkIfValid();
        return this.row.getBoolean(this.columnInfo.virtualIndex);
    }

    @Override
    public void setVirtual(boolean value) {
        this.realm.checkIfValid();
        this.row.setBoolean(this.columnInfo.virtualIndex, value);
    }

    @Override
    public double getLat() {
        this.realm.checkIfValid();
        return this.row.getDouble(this.columnInfo.latIndex);
    }

    @Override
    public void setLat(double value) {
        this.realm.checkIfValid();
        this.row.setDouble(this.columnInfo.latIndex, value);
    }

    @Override
    public double getLng() {
        this.realm.checkIfValid();
        return this.row.getDouble(this.columnInfo.lngIndex);
    }

    @Override
    public void setLng(double value) {
        this.realm.checkIfValid();
        this.row.setDouble(this.columnInfo.lngIndex, value);
    }

    @Override
    public float getRadius() {
        this.realm.checkIfValid();
        return this.row.getFloat(this.columnInfo.radiusIndex);
    }

    @Override
    public void setRadius(float value) {
        this.realm.checkIfValid();
        this.row.setFloat(this.columnInfo.radiusIndex, value);
    }

    public static Table initTable(ImplicitTransaction transaction) {
        if (!transaction.hasTable("class_ProxSeeBeaconRealm")) {
            Table table = transaction.getTable("class_ProxSeeBeaconRealm");
            table.addColumn(RealmFieldType.STRING, "id", false);
            table.addColumn(RealmFieldType.INTEGER, "major", false);
            table.addColumn(RealmFieldType.INTEGER, "minor", false);
            table.addColumn(RealmFieldType.STRING, "name", true);
            table.addColumn(RealmFieldType.STRING, "tokenizedTags", true);
            table.addColumn(RealmFieldType.BOOLEAN, "virtual", false);
            table.addColumn(RealmFieldType.DOUBLE, "lat", false);
            table.addColumn(RealmFieldType.DOUBLE, "lng", false);
            table.addColumn(RealmFieldType.FLOAT, "radius", false);
            table.addSearchIndex(table.getColumnIndex("id"));
            table.setPrimaryKey("id");
            return table;
        }
        return transaction.getTable("class_ProxSeeBeaconRealm");
    }

    public static ProxSeeBeaconRealmColumnInfo validateTable(ImplicitTransaction transaction) {
        if (transaction.hasTable("class_ProxSeeBeaconRealm")) {
            Table table = transaction.getTable("class_ProxSeeBeaconRealm");
            if (table.getColumnCount() != 9L) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Field count does not match - expected 9 but was " + table.getColumnCount());
            }
            HashMap<String, RealmFieldType> columnTypes = new HashMap<String, RealmFieldType>();
            for (long i = 0L; i < 9L; ++i) {
                columnTypes.put(table.getColumnName(i), table.getColumnType(i));
            }
            ProxSeeBeaconRealmColumnInfo columnInfo = new ProxSeeBeaconRealmColumnInfo(transaction.getPath(), table);
            if (!columnTypes.containsKey("id")) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Missing field 'id' in existing Realm file. Either remove field or migrate using io.realm.internal.Table.addColumn().");
            }
            if (columnTypes.get("id") != RealmFieldType.STRING) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Invalid type 'String' for field 'id' in existing Realm file.");
            }
            if (table.isColumnNullable(columnInfo.idIndex)) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Field 'id' does support null values in the existing Realm file. Remove @Required or @PrimaryKey from field 'id' or migrate using io.realm.internal.Table.convertColumnToNotNullable().");
            }
            if (table.getPrimaryKey() != table.getColumnIndex("id")) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Primary key not defined for field 'id' in existing Realm file. Add @PrimaryKey.");
            }
            if (!table.hasSearchIndex(table.getColumnIndex("id"))) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Index not defined for field 'id' in existing Realm file. Either set @Index or migrate using io.realm.internal.Table.removeSearchIndex().");
            }
            if (!columnTypes.containsKey("major")) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Missing field 'major' in existing Realm file. Either remove field or migrate using io.realm.internal.Table.addColumn().");
            }
            if (columnTypes.get("major") != RealmFieldType.INTEGER) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Invalid type 'int' for field 'major' in existing Realm file.");
            }
            if (table.isColumnNullable(columnInfo.majorIndex)) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Field 'major' does support null values in the existing Realm file. Use corresponding boxed type for field 'major' or migrate using io.realm.internal.Table.convertColumnToNotNullable().");
            }
            if (!columnTypes.containsKey("minor")) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Missing field 'minor' in existing Realm file. Either remove field or migrate using io.realm.internal.Table.addColumn().");
            }
            if (columnTypes.get("minor") != RealmFieldType.INTEGER) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Invalid type 'int' for field 'minor' in existing Realm file.");
            }
            if (table.isColumnNullable(columnInfo.minorIndex)) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Field 'minor' does support null values in the existing Realm file. Use corresponding boxed type for field 'minor' or migrate using io.realm.internal.Table.convertColumnToNotNullable().");
            }
            if (!columnTypes.containsKey("name")) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Missing field 'name' in existing Realm file. Either remove field or migrate using io.realm.internal.Table.addColumn().");
            }
            if (columnTypes.get("name") != RealmFieldType.STRING) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Invalid type 'String' for field 'name' in existing Realm file.");
            }
            if (!table.isColumnNullable(columnInfo.nameIndex)) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Field 'name' is required. Either set @Required to field 'name' or migrate using io.realm.internal.Table.convertColumnToNullable().");
            }
            if (!columnTypes.containsKey("tokenizedTags")) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Missing field 'tokenizedTags' in existing Realm file. Either remove field or migrate using io.realm.internal.Table.addColumn().");
            }
            if (columnTypes.get("tokenizedTags") != RealmFieldType.STRING) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Invalid type 'String' for field 'tokenizedTags' in existing Realm file.");
            }
            if (!table.isColumnNullable(columnInfo.tokenizedTagsIndex)) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Field 'tokenizedTags' is required. Either set @Required to field 'tokenizedTags' or migrate using io.realm.internal.Table.convertColumnToNullable().");
            }
            if (!columnTypes.containsKey("virtual")) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Missing field 'virtual' in existing Realm file. Either remove field or migrate using io.realm.internal.Table.addColumn().");
            }
            if (columnTypes.get("virtual") != RealmFieldType.BOOLEAN) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Invalid type 'boolean' for field 'virtual' in existing Realm file.");
            }
            if (table.isColumnNullable(columnInfo.virtualIndex)) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Field 'virtual' does support null values in the existing Realm file. Use corresponding boxed type for field 'virtual' or migrate using io.realm.internal.Table.convertColumnToNotNullable().");
            }
            if (!columnTypes.containsKey("lat")) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Missing field 'lat' in existing Realm file. Either remove field or migrate using io.realm.internal.Table.addColumn().");
            }
            if (columnTypes.get("lat") != RealmFieldType.DOUBLE) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Invalid type 'double' for field 'lat' in existing Realm file.");
            }
            if (table.isColumnNullable(columnInfo.latIndex)) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Field 'lat' does support null values in the existing Realm file. Use corresponding boxed type for field 'lat' or migrate using io.realm.internal.Table.convertColumnToNotNullable().");
            }
            if (!columnTypes.containsKey("lng")) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Missing field 'lng' in existing Realm file. Either remove field or migrate using io.realm.internal.Table.addColumn().");
            }
            if (columnTypes.get("lng") != RealmFieldType.DOUBLE) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Invalid type 'double' for field 'lng' in existing Realm file.");
            }
            if (table.isColumnNullable(columnInfo.lngIndex)) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Field 'lng' does support null values in the existing Realm file. Use corresponding boxed type for field 'lng' or migrate using io.realm.internal.Table.convertColumnToNotNullable().");
            }
            if (!columnTypes.containsKey("radius")) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Missing field 'radius' in existing Realm file. Either remove field or migrate using io.realm.internal.Table.addColumn().");
            }
            if (columnTypes.get("radius") != RealmFieldType.FLOAT) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Invalid type 'float' for field 'radius' in existing Realm file.");
            }
            if (table.isColumnNullable(columnInfo.radiusIndex)) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Field 'radius' does support null values in the existing Realm file. Use corresponding boxed type for field 'radius' or migrate using io.realm.internal.Table.convertColumnToNotNullable().");
            }
            return columnInfo;
        }
        throw new RealmMigrationNeededException(transaction.getPath(), "The ProxSeeBeaconRealm class is missing from the schema for this Realm.");
    }

    public static String getTableName() {
        return "class_ProxSeeBeaconRealm";
    }

    public static List<String> getFieldNames() {
        return FIELD_NAMES;
    }

    public static ProxSeeBeaconRealm createOrUpdateUsingJsonObject(Realm realm, JSONObject json, boolean update) throws JSONException {
        ProxSeeBeaconRealm obj = null;
        if (update) {
            long rowIndex;
            Table table = realm.getTable(ProxSeeBeaconRealm.class);
            long pkColumnIndex = table.getPrimaryKey();
            if (!json.isNull("id") && (rowIndex = table.findFirstString(pkColumnIndex, json.getString("id"))) != -1L) {
                obj = new ProxSeeBeaconRealmRealmProxy(realm.schema.getColumnInfo(ProxSeeBeaconRealm.class));
                obj.realm = realm;
                obj.row = table.getUncheckedRow(rowIndex);
            }
        }
        if (obj == null) {
            obj = json.has("id") ? (json.isNull("id") ? (ProxSeeBeaconRealm)realm.createObject(ProxSeeBeaconRealm.class, null) : (ProxSeeBeaconRealm)realm.createObject(ProxSeeBeaconRealm.class, (Object)json.getString("id"))) : (ProxSeeBeaconRealm)realm.createObject(ProxSeeBeaconRealm.class);
        }
        if (json.has("id")) {
            if (json.isNull("id")) {
                obj.setId(null);
            } else {
                obj.setId(json.getString("id"));
            }
        }
        if (json.has("major")) {
            if (json.isNull("major")) {
                throw new IllegalArgumentException("Trying to set non-nullable field major to null.");
            }
            obj.setMajor(json.getInt("major"));
        }
        if (json.has("minor")) {
            if (json.isNull("minor")) {
                throw new IllegalArgumentException("Trying to set non-nullable field minor to null.");
            }
            obj.setMinor(json.getInt("minor"));
        }
        if (json.has("name")) {
            if (json.isNull("name")) {
                obj.setName(null);
            } else {
                obj.setName(json.getString("name"));
            }
        }
        if (json.has("tokenizedTags")) {
            if (json.isNull("tokenizedTags")) {
                obj.setTokenizedTags(null);
            } else {
                obj.setTokenizedTags(json.getString("tokenizedTags"));
            }
        }
        if (json.has("virtual")) {
            if (json.isNull("virtual")) {
                throw new IllegalArgumentException("Trying to set non-nullable field virtual to null.");
            }
            obj.setVirtual(json.getBoolean("virtual"));
        }
        if (json.has("lat")) {
            if (json.isNull("lat")) {
                throw new IllegalArgumentException("Trying to set non-nullable field lat to null.");
            }
            obj.setLat(json.getDouble("lat"));
        }
        if (json.has("lng")) {
            if (json.isNull("lng")) {
                throw new IllegalArgumentException("Trying to set non-nullable field lng to null.");
            }
            obj.setLng(json.getDouble("lng"));
        }
        if (json.has("radius")) {
            if (json.isNull("radius")) {
                throw new IllegalArgumentException("Trying to set non-nullable field radius to null.");
            }
            obj.setRadius((float)json.getDouble("radius"));
        }
        return obj;
    }

    public static ProxSeeBeaconRealm createUsingJsonStream(Realm realm, JsonReader reader) throws IOException {
        ProxSeeBeaconRealm obj = (ProxSeeBeaconRealm)realm.createObject(ProxSeeBeaconRealm.class);
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("id")) {
                if (reader.peek() == JsonToken.NULL) {
                    reader.skipValue();
                    obj.setId(null);
                    continue;
                }
                obj.setId(reader.nextString());
                continue;
            }
            if (name.equals("major")) {
                if (reader.peek() == JsonToken.NULL) {
                    reader.skipValue();
                    throw new IllegalArgumentException("Trying to set non-nullable field major to null.");
                }
                obj.setMajor(reader.nextInt());
                continue;
            }
            if (name.equals("minor")) {
                if (reader.peek() == JsonToken.NULL) {
                    reader.skipValue();
                    throw new IllegalArgumentException("Trying to set non-nullable field minor to null.");
                }
                obj.setMinor(reader.nextInt());
                continue;
            }
            if (name.equals("name")) {
                if (reader.peek() == JsonToken.NULL) {
                    reader.skipValue();
                    obj.setName(null);
                    continue;
                }
                obj.setName(reader.nextString());
                continue;
            }
            if (name.equals("tokenizedTags")) {
                if (reader.peek() == JsonToken.NULL) {
                    reader.skipValue();
                    obj.setTokenizedTags(null);
                    continue;
                }
                obj.setTokenizedTags(reader.nextString());
                continue;
            }
            if (name.equals("virtual")) {
                if (reader.peek() == JsonToken.NULL) {
                    reader.skipValue();
                    throw new IllegalArgumentException("Trying to set non-nullable field virtual to null.");
                }
                obj.setVirtual(reader.nextBoolean());
                continue;
            }
            if (name.equals("lat")) {
                if (reader.peek() == JsonToken.NULL) {
                    reader.skipValue();
                    throw new IllegalArgumentException("Trying to set non-nullable field lat to null.");
                }
                obj.setLat(reader.nextDouble());
                continue;
            }
            if (name.equals("lng")) {
                if (reader.peek() == JsonToken.NULL) {
                    reader.skipValue();
                    throw new IllegalArgumentException("Trying to set non-nullable field lng to null.");
                }
                obj.setLng(reader.nextDouble());
                continue;
            }
            if (name.equals("radius")) {
                if (reader.peek() == JsonToken.NULL) {
                    reader.skipValue();
                    throw new IllegalArgumentException("Trying to set non-nullable field radius to null.");
                }
                obj.setRadius((float)reader.nextDouble());
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return obj;
    }

    public static ProxSeeBeaconRealm copyOrUpdate(Realm realm, ProxSeeBeaconRealm object, boolean update, Map<RealmObject, RealmObjectProxy> cache) {
        if (object.realm != null && object.realm.getPath().equals(realm.getPath())) {
            return object;
        }
        ProxSeeBeaconRealmRealmProxy realmObject = null;
        boolean canUpdate = update;
        if (canUpdate) {
            Table table = realm.getTable(ProxSeeBeaconRealm.class);
            long pkColumnIndex = table.getPrimaryKey();
            if (object.getId() == null) {
                throw new IllegalArgumentException("Primary key value must not be null.");
            }
            long rowIndex = table.findFirstString(pkColumnIndex, object.getId());
            if (rowIndex != -1L) {
                realmObject = new ProxSeeBeaconRealmRealmProxy(realm.schema.getColumnInfo(ProxSeeBeaconRealm.class));
                realmObject.realm = realm;
                realmObject.row = table.getUncheckedRow(rowIndex);
                cache.put(object, realmObject);
            } else {
                canUpdate = false;
            }
        }
        if (canUpdate) {
            return ProxSeeBeaconRealmRealmProxy.update(realm, realmObject, object, cache);
        }
        return ProxSeeBeaconRealmRealmProxy.copy(realm, object, update, cache);
    }

    public static ProxSeeBeaconRealm copy(Realm realm, ProxSeeBeaconRealm newObject, boolean update, Map<RealmObject, RealmObjectProxy> cache) {
        ProxSeeBeaconRealm realmObject = (ProxSeeBeaconRealm)realm.createObject(ProxSeeBeaconRealm.class, (Object)newObject.getId());
        cache.put(newObject, (RealmObjectProxy)realmObject);
        realmObject.setId(newObject.getId());
        realmObject.setMajor(newObject.getMajor());
        realmObject.setMinor(newObject.getMinor());
        realmObject.setName(newObject.getName());
        realmObject.setTokenizedTags(newObject.getTokenizedTags());
        realmObject.setVirtual(newObject.isVirtual());
        realmObject.setLat(newObject.getLat());
        realmObject.setLng(newObject.getLng());
        realmObject.setRadius(newObject.getRadius());
        return realmObject;
    }

    public static ProxSeeBeaconRealm createDetachedCopy(ProxSeeBeaconRealm realmObject, int currentDepth, int maxDepth, Map<RealmObject, RealmObjectProxy.CacheData<RealmObject>> cache) {
        ProxSeeBeaconRealm standaloneObject;
        if (currentDepth > maxDepth || realmObject == null) {
            return null;
        }
        RealmObjectProxy.CacheData<RealmObject> cachedObject = cache.get(realmObject);
        if (cachedObject != null) {
            if (currentDepth >= cachedObject.minDepth) {
                return (ProxSeeBeaconRealm)cachedObject.object;
            }
            standaloneObject = (ProxSeeBeaconRealm)cachedObject.object;
            cachedObject.minDepth = currentDepth;
        } else {
            standaloneObject = new ProxSeeBeaconRealm();
            cache.put(realmObject, (RealmObjectProxy.CacheData<RealmObject>)new RealmObjectProxy.CacheData(currentDepth, (RealmObject)standaloneObject));
        }
        standaloneObject.setId(realmObject.getId());
        standaloneObject.setMajor(realmObject.getMajor());
        standaloneObject.setMinor(realmObject.getMinor());
        standaloneObject.setName(realmObject.getName());
        standaloneObject.setTokenizedTags(realmObject.getTokenizedTags());
        standaloneObject.setVirtual(realmObject.isVirtual());
        standaloneObject.setLat(realmObject.getLat());
        standaloneObject.setLng(realmObject.getLng());
        standaloneObject.setRadius(realmObject.getRadius());
        return standaloneObject;
    }

    static ProxSeeBeaconRealm update(Realm realm, ProxSeeBeaconRealm realmObject, ProxSeeBeaconRealm newObject, Map<RealmObject, RealmObjectProxy> cache) {
        realmObject.setMajor(newObject.getMajor());
        realmObject.setMinor(newObject.getMinor());
        realmObject.setName(newObject.getName());
        realmObject.setTokenizedTags(newObject.getTokenizedTags());
        realmObject.setVirtual(newObject.isVirtual());
        realmObject.setLat(newObject.getLat());
        realmObject.setLng(newObject.getLng());
        realmObject.setRadius(newObject.getRadius());
        return realmObject;
    }

    public String toString() {
        if (!this.isValid()) {
            return "Invalid object";
        }
        StringBuilder stringBuilder = new StringBuilder("ProxSeeBeaconRealm = [");
        stringBuilder.append("{id:");
        stringBuilder.append(this.getId());
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{major:");
        stringBuilder.append(this.getMajor());
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{minor:");
        stringBuilder.append(this.getMinor());
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{name:");
        stringBuilder.append(this.getName() != null ? this.getName() : "null");
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{tokenizedTags:");
        stringBuilder.append(this.getTokenizedTags() != null ? this.getTokenizedTags() : "null");
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{virtual:");
        stringBuilder.append(this.isVirtual());
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{lat:");
        stringBuilder.append(this.getLat());
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{lng:");
        stringBuilder.append(this.getLng());
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{radius:");
        stringBuilder.append(this.getRadius());
        stringBuilder.append("}");
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public int hashCode() {
        String realmName = this.realm.getPath();
        String tableName = this.row.getTable().getName();
        long rowIndex = this.row.getIndex();
        int result = 17;
        result = 31 * result + (realmName != null ? realmName.hashCode() : 0);
        result = 31 * result + (tableName != null ? tableName.hashCode() : 0);
        result = 31 * result + (int)(rowIndex ^ rowIndex >>> 32);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProxSeeBeaconRealmRealmProxy aProxSeeBeaconRealm = (ProxSeeBeaconRealmRealmProxy)o;
        String path = this.realm.getPath();
        String otherPath = aProxSeeBeaconRealm.realm.getPath();
        if (path != null ? !path.equals(otherPath) : otherPath != null) {
            return false;
        }
        String tableName = this.row.getTable().getName();
        String otherTableName = aProxSeeBeaconRealm.row.getTable().getName();
        if (tableName != null ? !tableName.equals(otherTableName) : otherTableName != null) {
            return false;
        }
        return this.row.getIndex() == aProxSeeBeaconRealm.row.getIndex();
    }

    static {
        ArrayList<String> fieldNames = new ArrayList<String>();
        fieldNames.add("id");
        fieldNames.add("major");
        fieldNames.add("minor");
        fieldNames.add("name");
        fieldNames.add("tokenizedTags");
        fieldNames.add("virtual");
        fieldNames.add("lat");
        fieldNames.add("lng");
        fieldNames.add("radius");
        FIELD_NAMES = Collections.unmodifiableList(fieldNames);
    }

    static final class ProxSeeBeaconRealmColumnInfo
    extends ColumnInfo {
        public final long idIndex;
        public final long majorIndex;
        public final long minorIndex;
        public final long nameIndex;
        public final long tokenizedTagsIndex;
        public final long virtualIndex;
        public final long latIndex;
        public final long lngIndex;
        public final long radiusIndex;

        ProxSeeBeaconRealmColumnInfo(String path, Table table) {
            HashMap<String, Long> indicesMap = new HashMap<String, Long>(9);
            this.idIndex = this.getValidColumnIndex(path, table, "ProxSeeBeaconRealm", "id");
            indicesMap.put("id", this.idIndex);
            this.majorIndex = this.getValidColumnIndex(path, table, "ProxSeeBeaconRealm", "major");
            indicesMap.put("major", this.majorIndex);
            this.minorIndex = this.getValidColumnIndex(path, table, "ProxSeeBeaconRealm", "minor");
            indicesMap.put("minor", this.minorIndex);
            this.nameIndex = this.getValidColumnIndex(path, table, "ProxSeeBeaconRealm", "name");
            indicesMap.put("name", this.nameIndex);
            this.tokenizedTagsIndex = this.getValidColumnIndex(path, table, "ProxSeeBeaconRealm", "tokenizedTags");
            indicesMap.put("tokenizedTags", this.tokenizedTagsIndex);
            this.virtualIndex = this.getValidColumnIndex(path, table, "ProxSeeBeaconRealm", "virtual");
            indicesMap.put("virtual", this.virtualIndex);
            this.latIndex = this.getValidColumnIndex(path, table, "ProxSeeBeaconRealm", "lat");
            indicesMap.put("lat", this.latIndex);
            this.lngIndex = this.getValidColumnIndex(path, table, "ProxSeeBeaconRealm", "lng");
            indicesMap.put("lng", this.lngIndex);
            this.radiusIndex = this.getValidColumnIndex(path, table, "ProxSeeBeaconRealm", "radius");
            indicesMap.put("radius", this.radiusIndex);
            this.setIndicesMap(indicesMap);
        }
    }
}

