/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import android.util.JsonReader;
import android.util.JsonToken;
import io.proxsee.sdk.entity.VirtualRegionRealm;
import io.realm.Realm;
import io.realm.RealmFieldType;
import io.realm.RealmObject;
import io.realm.exceptions.RealmMigrationNeededException;
import io.realm.internal.ColumnInfo;
import io.realm.internal.ImplicitTransaction;
import io.realm.internal.RealmObjectProxy;
import io.realm.internal.Table;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class VirtualRegionRealmRealmProxy
extends VirtualRegionRealm
implements RealmObjectProxy {
    private final VirtualRegionRealmColumnInfo columnInfo;
    private static final List<String> FIELD_NAMES;

    VirtualRegionRealmRealmProxy(ColumnInfo columnInfo) {
        this.columnInfo = (VirtualRegionRealmColumnInfo)columnInfo;
    }

    @Override
    public String getId() {
        this.realm.checkIfValid();
        return this.row.getString(this.columnInfo.idIndex);
    }

    @Override
    public void setId(String value) {
        this.realm.checkIfValid();
        if (value == null) {
            throw new IllegalArgumentException("Trying to set non-nullable field id to null.");
        }
        this.row.setString(this.columnInfo.idIndex, value);
    }

    @Override
    public int getMajor() {
        this.realm.checkIfValid();
        return (int)this.row.getLong(this.columnInfo.majorIndex);
    }

    @Override
    public void setMajor(int value) {
        this.realm.checkIfValid();
        this.row.setLong(this.columnInfo.majorIndex, (long)value);
    }

    @Override
    public int getMinor() {
        this.realm.checkIfValid();
        return (int)this.row.getLong(this.columnInfo.minorIndex);
    }

    @Override
    public void setMinor(int value) {
        this.realm.checkIfValid();
        this.row.setLong(this.columnInfo.minorIndex, (long)value);
    }

    @Override
    public double getLng() {
        this.realm.checkIfValid();
        return this.row.getDouble(this.columnInfo.lngIndex);
    }

    @Override
    public void setLng(double value) {
        this.realm.checkIfValid();
        this.row.setDouble(this.columnInfo.lngIndex, value);
    }

    @Override
    public double getLat() {
        this.realm.checkIfValid();
        return this.row.getDouble(this.columnInfo.latIndex);
    }

    @Override
    public void setLat(double value) {
        this.realm.checkIfValid();
        this.row.setDouble(this.columnInfo.latIndex, value);
    }

    @Override
    public float getRadius() {
        this.realm.checkIfValid();
        return this.row.getFloat(this.columnInfo.radiusIndex);
    }

    @Override
    public void setRadius(float value) {
        this.realm.checkIfValid();
        this.row.setFloat(this.columnInfo.radiusIndex, value);
    }

    @Override
    public String getName() {
        this.realm.checkIfValid();
        return this.row.getString(this.columnInfo.nameIndex);
    }

    @Override
    public void setName(String value) {
        this.realm.checkIfValid();
        if (value == null) {
            this.row.setNull(this.columnInfo.nameIndex);
            return;
        }
        this.row.setString(this.columnInfo.nameIndex, value);
    }

    public static Table initTable(ImplicitTransaction transaction) {
        if (!transaction.hasTable("class_VirtualRegionRealm")) {
            Table table = transaction.getTable("class_VirtualRegionRealm");
            table.addColumn(RealmFieldType.STRING, "id", false);
            table.addColumn(RealmFieldType.INTEGER, "major", false);
            table.addColumn(RealmFieldType.INTEGER, "minor", false);
            table.addColumn(RealmFieldType.DOUBLE, "lng", false);
            table.addColumn(RealmFieldType.DOUBLE, "lat", false);
            table.addColumn(RealmFieldType.FLOAT, "radius", false);
            table.addColumn(RealmFieldType.STRING, "name", true);
            table.addSearchIndex(table.getColumnIndex("id"));
            table.setPrimaryKey("id");
            return table;
        }
        return transaction.getTable("class_VirtualRegionRealm");
    }

    public static VirtualRegionRealmColumnInfo validateTable(ImplicitTransaction transaction) {
        if (transaction.hasTable("class_VirtualRegionRealm")) {
            Table table = transaction.getTable("class_VirtualRegionRealm");
            if (table.getColumnCount() != 7L) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Field count does not match - expected 7 but was " + table.getColumnCount());
            }
            HashMap<String, RealmFieldType> columnTypes = new HashMap<String, RealmFieldType>();
            for (long i = 0L; i < 7L; ++i) {
                columnTypes.put(table.getColumnName(i), table.getColumnType(i));
            }
            VirtualRegionRealmColumnInfo columnInfo = new VirtualRegionRealmColumnInfo(transaction.getPath(), table);
            if (!columnTypes.containsKey("id")) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Missing field 'id' in existing Realm file. Either remove field or migrate using io.realm.internal.Table.addColumn().");
            }
            if (columnTypes.get("id") != RealmFieldType.STRING) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Invalid type 'String' for field 'id' in existing Realm file.");
            }
            if (table.isColumnNullable(columnInfo.idIndex)) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Field 'id' does support null values in the existing Realm file. Remove @Required or @PrimaryKey from field 'id' or migrate using io.realm.internal.Table.convertColumnToNotNullable().");
            }
            if (table.getPrimaryKey() != table.getColumnIndex("id")) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Primary key not defined for field 'id' in existing Realm file. Add @PrimaryKey.");
            }
            if (!table.hasSearchIndex(table.getColumnIndex("id"))) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Index not defined for field 'id' in existing Realm file. Either set @Index or migrate using io.realm.internal.Table.removeSearchIndex().");
            }
            if (!columnTypes.containsKey("major")) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Missing field 'major' in existing Realm file. Either remove field or migrate using io.realm.internal.Table.addColumn().");
            }
            if (columnTypes.get("major") != RealmFieldType.INTEGER) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Invalid type 'int' for field 'major' in existing Realm file.");
            }
            if (table.isColumnNullable(columnInfo.majorIndex)) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Field 'major' does support null values in the existing Realm file. Use corresponding boxed type for field 'major' or migrate using io.realm.internal.Table.convertColumnToNotNullable().");
            }
            if (!columnTypes.containsKey("minor")) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Missing field 'minor' in existing Realm file. Either remove field or migrate using io.realm.internal.Table.addColumn().");
            }
            if (columnTypes.get("minor") != RealmFieldType.INTEGER) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Invalid type 'int' for field 'minor' in existing Realm file.");
            }
            if (table.isColumnNullable(columnInfo.minorIndex)) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Field 'minor' does support null values in the existing Realm file. Use corresponding boxed type for field 'minor' or migrate using io.realm.internal.Table.convertColumnToNotNullable().");
            }
            if (!columnTypes.containsKey("lng")) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Missing field 'lng' in existing Realm file. Either remove field or migrate using io.realm.internal.Table.addColumn().");
            }
            if (columnTypes.get("lng") != RealmFieldType.DOUBLE) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Invalid type 'double' for field 'lng' in existing Realm file.");
            }
            if (table.isColumnNullable(columnInfo.lngIndex)) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Field 'lng' does support null values in the existing Realm file. Use corresponding boxed type for field 'lng' or migrate using io.realm.internal.Table.convertColumnToNotNullable().");
            }
            if (!columnTypes.containsKey("lat")) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Missing field 'lat' in existing Realm file. Either remove field or migrate using io.realm.internal.Table.addColumn().");
            }
            if (columnTypes.get("lat") != RealmFieldType.DOUBLE) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Invalid type 'double' for field 'lat' in existing Realm file.");
            }
            if (table.isColumnNullable(columnInfo.latIndex)) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Field 'lat' does support null values in the existing Realm file. Use corresponding boxed type for field 'lat' or migrate using io.realm.internal.Table.convertColumnToNotNullable().");
            }
            if (!columnTypes.containsKey("radius")) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Missing field 'radius' in existing Realm file. Either remove field or migrate using io.realm.internal.Table.addColumn().");
            }
            if (columnTypes.get("radius") != RealmFieldType.FLOAT) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Invalid type 'float' for field 'radius' in existing Realm file.");
            }
            if (table.isColumnNullable(columnInfo.radiusIndex)) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Field 'radius' does support null values in the existing Realm file. Use corresponding boxed type for field 'radius' or migrate using io.realm.internal.Table.convertColumnToNotNullable().");
            }
            if (!columnTypes.containsKey("name")) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Missing field 'name' in existing Realm file. Either remove field or migrate using io.realm.internal.Table.addColumn().");
            }
            if (columnTypes.get("name") != RealmFieldType.STRING) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Invalid type 'String' for field 'name' in existing Realm file.");
            }
            if (!table.isColumnNullable(columnInfo.nameIndex)) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Field 'name' is required. Either set @Required to field 'name' or migrate using io.realm.internal.Table.convertColumnToNullable().");
            }
            return columnInfo;
        }
        throw new RealmMigrationNeededException(transaction.getPath(), "The VirtualRegionRealm class is missing from the schema for this Realm.");
    }

    public static String getTableName() {
        return "class_VirtualRegionRealm";
    }

    public static List<String> getFieldNames() {
        return FIELD_NAMES;
    }

    public static VirtualRegionRealm createOrUpdateUsingJsonObject(Realm realm, JSONObject json, boolean update) throws JSONException {
        VirtualRegionRealm obj = null;
        if (update) {
            long rowIndex;
            Table table = realm.getTable(VirtualRegionRealm.class);
            long pkColumnIndex = table.getPrimaryKey();
            if (!json.isNull("id") && (rowIndex = table.findFirstString(pkColumnIndex, json.getString("id"))) != -1L) {
                obj = new VirtualRegionRealmRealmProxy(realm.schema.getColumnInfo(VirtualRegionRealm.class));
                obj.realm = realm;
                obj.row = table.getUncheckedRow(rowIndex);
            }
        }
        if (obj == null) {
            obj = json.has("id") ? (json.isNull("id") ? (VirtualRegionRealm)realm.createObject(VirtualRegionRealm.class, null) : (VirtualRegionRealm)realm.createObject(VirtualRegionRealm.class, (Object)json.getString("id"))) : (VirtualRegionRealm)realm.createObject(VirtualRegionRealm.class);
        }
        if (json.has("id")) {
            if (json.isNull("id")) {
                obj.setId(null);
            } else {
                obj.setId(json.getString("id"));
            }
        }
        if (json.has("major")) {
            if (json.isNull("major")) {
                throw new IllegalArgumentException("Trying to set non-nullable field major to null.");
            }
            obj.setMajor(json.getInt("major"));
        }
        if (json.has("minor")) {
            if (json.isNull("minor")) {
                throw new IllegalArgumentException("Trying to set non-nullable field minor to null.");
            }
            obj.setMinor(json.getInt("minor"));
        }
        if (json.has("lng")) {
            if (json.isNull("lng")) {
                throw new IllegalArgumentException("Trying to set non-nullable field lng to null.");
            }
            obj.setLng(json.getDouble("lng"));
        }
        if (json.has("lat")) {
            if (json.isNull("lat")) {
                throw new IllegalArgumentException("Trying to set non-nullable field lat to null.");
            }
            obj.setLat(json.getDouble("lat"));
        }
        if (json.has("radius")) {
            if (json.isNull("radius")) {
                throw new IllegalArgumentException("Trying to set non-nullable field radius to null.");
            }
            obj.setRadius((float)json.getDouble("radius"));
        }
        if (json.has("name")) {
            if (json.isNull("name")) {
                obj.setName(null);
            } else {
                obj.setName(json.getString("name"));
            }
        }
        return obj;
    }

    public static VirtualRegionRealm createUsingJsonStream(Realm realm, JsonReader reader) throws IOException {
        VirtualRegionRealm obj = (VirtualRegionRealm)realm.createObject(VirtualRegionRealm.class);
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("id")) {
                if (reader.peek() == JsonToken.NULL) {
                    reader.skipValue();
                    obj.setId(null);
                    continue;
                }
                obj.setId(reader.nextString());
                continue;
            }
            if (name.equals("major")) {
                if (reader.peek() == JsonToken.NULL) {
                    reader.skipValue();
                    throw new IllegalArgumentException("Trying to set non-nullable field major to null.");
                }
                obj.setMajor(reader.nextInt());
                continue;
            }
            if (name.equals("minor")) {
                if (reader.peek() == JsonToken.NULL) {
                    reader.skipValue();
                    throw new IllegalArgumentException("Trying to set non-nullable field minor to null.");
                }
                obj.setMinor(reader.nextInt());
                continue;
            }
            if (name.equals("lng")) {
                if (reader.peek() == JsonToken.NULL) {
                    reader.skipValue();
                    throw new IllegalArgumentException("Trying to set non-nullable field lng to null.");
                }
                obj.setLng(reader.nextDouble());
                continue;
            }
            if (name.equals("lat")) {
                if (reader.peek() == JsonToken.NULL) {
                    reader.skipValue();
                    throw new IllegalArgumentException("Trying to set non-nullable field lat to null.");
                }
                obj.setLat(reader.nextDouble());
                continue;
            }
            if (name.equals("radius")) {
                if (reader.peek() == JsonToken.NULL) {
                    reader.skipValue();
                    throw new IllegalArgumentException("Trying to set non-nullable field radius to null.");
                }
                obj.setRadius((float)reader.nextDouble());
                continue;
            }
            if (name.equals("name")) {
                if (reader.peek() == JsonToken.NULL) {
                    reader.skipValue();
                    obj.setName(null);
                    continue;
                }
                obj.setName(reader.nextString());
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return obj;
    }

    public static VirtualRegionRealm copyOrUpdate(Realm realm, VirtualRegionRealm object, boolean update, Map<RealmObject, RealmObjectProxy> cache) {
        if (object.realm != null && object.realm.getPath().equals(realm.getPath())) {
            return object;
        }
        VirtualRegionRealmRealmProxy realmObject = null;
        boolean canUpdate = update;
        if (canUpdate) {
            Table table = realm.getTable(VirtualRegionRealm.class);
            long pkColumnIndex = table.getPrimaryKey();
            if (object.getId() == null) {
                throw new IllegalArgumentException("Primary key value must not be null.");
            }
            long rowIndex = table.findFirstString(pkColumnIndex, object.getId());
            if (rowIndex != -1L) {
                realmObject = new VirtualRegionRealmRealmProxy(realm.schema.getColumnInfo(VirtualRegionRealm.class));
                realmObject.realm = realm;
                realmObject.row = table.getUncheckedRow(rowIndex);
                cache.put(object, realmObject);
            } else {
                canUpdate = false;
            }
        }
        if (canUpdate) {
            return VirtualRegionRealmRealmProxy.update(realm, realmObject, object, cache);
        }
        return VirtualRegionRealmRealmProxy.copy(realm, object, update, cache);
    }

    public static VirtualRegionRealm copy(Realm realm, VirtualRegionRealm newObject, boolean update, Map<RealmObject, RealmObjectProxy> cache) {
        VirtualRegionRealm realmObject = (VirtualRegionRealm)realm.createObject(VirtualRegionRealm.class, (Object)newObject.getId());
        cache.put(newObject, (RealmObjectProxy)realmObject);
        realmObject.setId(newObject.getId());
        realmObject.setMajor(newObject.getMajor());
        realmObject.setMinor(newObject.getMinor());
        realmObject.setLng(newObject.getLng());
        realmObject.setLat(newObject.getLat());
        realmObject.setRadius(newObject.getRadius());
        realmObject.setName(newObject.getName());
        return realmObject;
    }

    public static VirtualRegionRealm createDetachedCopy(VirtualRegionRealm realmObject, int currentDepth, int maxDepth, Map<RealmObject, RealmObjectProxy.CacheData<RealmObject>> cache) {
        VirtualRegionRealm standaloneObject;
        if (currentDepth > maxDepth || realmObject == null) {
            return null;
        }
        RealmObjectProxy.CacheData<RealmObject> cachedObject = cache.get(realmObject);
        if (cachedObject != null) {
            if (currentDepth >= cachedObject.minDepth) {
                return (VirtualRegionRealm)cachedObject.object;
            }
            standaloneObject = (VirtualRegionRealm)cachedObject.object;
            cachedObject.minDepth = currentDepth;
        } else {
            standaloneObject = new VirtualRegionRealm();
            cache.put(realmObject, (RealmObjectProxy.CacheData<RealmObject>)new RealmObjectProxy.CacheData(currentDepth, (RealmObject)standaloneObject));
        }
        standaloneObject.setId(realmObject.getId());
        standaloneObject.setMajor(realmObject.getMajor());
        standaloneObject.setMinor(realmObject.getMinor());
        standaloneObject.setLng(realmObject.getLng());
        standaloneObject.setLat(realmObject.getLat());
        standaloneObject.setRadius(realmObject.getRadius());
        standaloneObject.setName(realmObject.getName());
        return standaloneObject;
    }

    static VirtualRegionRealm update(Realm realm, VirtualRegionRealm realmObject, VirtualRegionRealm newObject, Map<RealmObject, RealmObjectProxy> cache) {
        realmObject.setMajor(newObject.getMajor());
        realmObject.setMinor(newObject.getMinor());
        realmObject.setLng(newObject.getLng());
        realmObject.setLat(newObject.getLat());
        realmObject.setRadius(newObject.getRadius());
        realmObject.setName(newObject.getName());
        return realmObject;
    }

    public String toString() {
        if (!this.isValid()) {
            return "Invalid object";
        }
        StringBuilder stringBuilder = new StringBuilder("VirtualRegionRealm = [");
        stringBuilder.append("{id:");
        stringBuilder.append(this.getId());
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{major:");
        stringBuilder.append(this.getMajor());
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{minor:");
        stringBuilder.append(this.getMinor());
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{lng:");
        stringBuilder.append(this.getLng());
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{lat:");
        stringBuilder.append(this.getLat());
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{radius:");
        stringBuilder.append(this.getRadius());
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{name:");
        stringBuilder.append(this.getName() != null ? this.getName() : "null");
        stringBuilder.append("}");
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public int hashCode() {
        String realmName = this.realm.getPath();
        String tableName = this.row.getTable().getName();
        long rowIndex = this.row.getIndex();
        int result = 17;
        result = 31 * result + (realmName != null ? realmName.hashCode() : 0);
        result = 31 * result + (tableName != null ? tableName.hashCode() : 0);
        result = 31 * result + (int)(rowIndex ^ rowIndex >>> 32);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VirtualRegionRealmRealmProxy aVirtualRegionRealm = (VirtualRegionRealmRealmProxy)o;
        String path = this.realm.getPath();
        String otherPath = aVirtualRegionRealm.realm.getPath();
        if (path != null ? !path.equals(otherPath) : otherPath != null) {
            return false;
        }
        String tableName = this.row.getTable().getName();
        String otherTableName = aVirtualRegionRealm.row.getTable().getName();
        if (tableName != null ? !tableName.equals(otherTableName) : otherTableName != null) {
            return false;
        }
        return this.row.getIndex() == aVirtualRegionRealm.row.getIndex();
    }

    static {
        ArrayList<String> fieldNames = new ArrayList<String>();
        fieldNames.add("id");
        fieldNames.add("major");
        fieldNames.add("minor");
        fieldNames.add("lng");
        fieldNames.add("lat");
        fieldNames.add("radius");
        fieldNames.add("name");
        FIELD_NAMES = Collections.unmodifiableList(fieldNames);
    }

    static final class VirtualRegionRealmColumnInfo
    extends ColumnInfo {
        public final long idIndex;
        public final long majorIndex;
        public final long minorIndex;
        public final long lngIndex;
        public final long latIndex;
        public final long radiusIndex;
        public final long nameIndex;

        VirtualRegionRealmColumnInfo(String path, Table table) {
            HashMap<String, Long> indicesMap = new HashMap<String, Long>(7);
            this.idIndex = this.getValidColumnIndex(path, table, "VirtualRegionRealm", "id");
            indicesMap.put("id", this.idIndex);
            this.majorIndex = this.getValidColumnIndex(path, table, "VirtualRegionRealm", "major");
            indicesMap.put("major", this.majorIndex);
            this.minorIndex = this.getValidColumnIndex(path, table, "VirtualRegionRealm", "minor");
            indicesMap.put("minor", this.minorIndex);
            this.lngIndex = this.getValidColumnIndex(path, table, "VirtualRegionRealm", "lng");
            indicesMap.put("lng", this.lngIndex);
            this.latIndex = this.getValidColumnIndex(path, table, "VirtualRegionRealm", "lat");
            indicesMap.put("lat", this.latIndex);
            this.radiusIndex = this.getValidColumnIndex(path, table, "VirtualRegionRealm", "radius");
            indicesMap.put("radius", this.radiusIndex);
            this.nameIndex = this.getValidColumnIndex(path, table, "VirtualRegionRealm", "name");
            indicesMap.put("name", this.nameIndex);
            this.setIndicesMap(indicesMap);
        }
    }
}

