/*
 * Decompiled with CFR 0.152.
 */
package io.proxsee.sdk;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import io.proxsee.sdk.misc.Utils;
import java.util.HashMap;

public class ProxSeeContext {
    public static final String DEFAULT_IBEACONS_LAYOUT = "m:2-3=0215,i:4-19,i:20-21,i:22-23,p:24-24";
    public static final String DEFAULT_BASE_URL = "https://app.proxsee.io";
    public static final long DEFAULT_BLUETOOTH_SCAN_PERIOD = 1100L;
    public static final long DEFAULT_BLUETOOTH_SCAN_BETWEEN_PERIOD = 10000L;
    public static final int DEFAULT_CYCLE_EXIT_EXPIRE_COUNT = 6;
    public static final long DEFAULT_CACHE_EXPIRY = 10800000L;
    public static final String BASE_URL_KEY = "BASE_URL_KEY";
    public static final String BLUETOOTH_SCAN_PERIOD_KEY = "BLUETOOTH_SCAN_PERIOD_KEY";
    public static final String BLUETOOTH_SCAN_BETWEEN_PERIOD_KEY = "BLUETOOTH_SCAN_BETWEEN_PERIOD_KEY";
    public static final String CYCLE_EXIT_EXPIRE_COUNT_KEY = "CYCLE_EXIT_EXPIRE_COUNT_KEY";
    public static final String CACHE_EXPIRY_KEY = "CACHE_EXPIRY_KEY";
    private String apiKey;
    private final String apiURL;
    private final String version;
    private final Context applicationContext;
    private final long bluetoothScanPeriod;
    private final long bluetoothScanBetweenPeriod;
    private final String beaconLayout;
    private final int cycleExitExpireCount;
    private final long cacheExpiry;

    public ProxSeeContext(Context context, String apiKey) {
        this.applicationContext = context;
        this.apiKey = apiKey;
        this.version = "2.4.0";
        this.beaconLayout = DEFAULT_IBEACONS_LAYOUT;
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)context);
        this.apiURL = prefs.getString(BASE_URL_KEY, DEFAULT_BASE_URL);
        this.bluetoothScanPeriod = prefs.getLong(BLUETOOTH_SCAN_PERIOD_KEY, 1100L);
        this.bluetoothScanBetweenPeriod = prefs.getLong(BLUETOOTH_SCAN_BETWEEN_PERIOD_KEY, 10000L);
        this.cycleExitExpireCount = prefs.getInt(CYCLE_EXIT_EXPIRE_COUNT_KEY, 6);
        this.cacheExpiry = prefs.getLong(CACHE_EXPIRY_KEY, 10800000L);
    }

    public String getApiURL() {
        return this.apiURL;
    }

    public Context getApplicationContext() {
        return this.applicationContext;
    }

    public HashMap<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + this.apiKey);
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        headers.put("Accept-Encoding", "UTF-8");
        headers.put("X-ProxSee-SDKPlatform", "android");
        headers.put("X-ProxSee-SDKVersion", this.version);
        return headers;
    }

    public void flushApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getFingerprint() {
        return Utils.createHash(this.apiKey + "-" + this.apiURL);
    }

    public long getBluetoothScanPeriod() {
        return this.bluetoothScanPeriod;
    }

    public long getBluetoothScanBetweenPeriod() {
        return this.bluetoothScanBetweenPeriod;
    }

    public int getCycleExitExpireCount() {
        return this.cycleExitExpireCount;
    }

    public long getCacheExpiry() {
        return this.cacheExpiry;
    }

    public String getBeaconLayout() {
        return this.beaconLayout;
    }
}

