/*
 * Decompiled with CFR 0.152.
 */
package io.proxsee.sdk;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.util.Log;
import io.proxsee.sdk.BackgroundService;
import io.proxsee.sdk.DeviceStateMonitor;
import io.proxsee.sdk.ProxSeeContext;
import io.proxsee.sdk.cache.InternalCache;
import io.proxsee.sdk.client.Callback;
import io.proxsee.sdk.client.request.UpdateMetadataRequest;
import io.proxsee.sdk.client.response.UpdateMetadataResponse;
import io.proxsee.sdk.dagger.DaggerProxSeeSDKComponent;
import io.proxsee.sdk.dagger.ProxSeeSDKComponent;
import io.proxsee.sdk.dagger.ProxSeeSDKModule;
import io.proxsee.sdk.intent.SDKReset;
import io.proxsee.sdk.intent.SDKStarted;
import io.proxsee.sdk.intent.SDKStopped;
import io.proxsee.sdk.misc.Preference;
import io.proxsee.sdk.misc.Utils;
import io.proxsee.sdk.permissions.PermissionsMonitor;
import io.proxsee.sdk.service.ProxSeeService;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;

public class ProxSeeSDKManager {
    private static final String TAG = ProxSeeSDKManager.class.getSimpleName();
    private static final String STARTED = "STARTED";
    private static final Object INITIALIZATION_LOCK = new Object();
    private static final Object START_VALUE_LOCK = new Object();
    private static ProxSeeSDKManager INSTANCE;
    private ProxSeeSDKComponent proxSeeSDKComponent;
    private final Intent mKeepAlive;
    @Inject
    @Named(value="Real")
    ProxSeeService realBeaconService;
    @Inject
    @Named(value="Virtual")
    ProxSeeService virtualBeaconService;
    @Inject
    Context appContext;
    @Inject
    ProxSeeContext proxSeeContext;
    @Inject
    Preference preference;
    @Inject
    Handler proxseeSDKHandler;
    @Inject
    InternalCache internalCache;
    @Inject
    DeviceStateMonitor deviceStateMonitor;
    @Inject
    PermissionsMonitor permissionsMonitor;

    private ProxSeeSDKManager(Context context) {
        this.mKeepAlive = new Intent(context, BackgroundService.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProxSeeSDKManager getInstance() {
        Object object = INITIALIZATION_LOCK;
        synchronized (object) {
            if (INSTANCE == null) {
                throw new RuntimeException("ProxSee SDK must be initialized");
            }
            return INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(final Context context, final String apiKey) {
        Object object = INITIALIZATION_LOCK;
        synchronized (object) {
            Log.d((String)TAG, (String)"Initializing ProxSee SDK...");
            if (INSTANCE != null) {
                ProxSeeSDKManager manager = INSTANCE;
                INSTANCE.reInitialiseSDK(apiKey);
                return;
            }
            if (Utils.isAndroidOsCompatible()) {
                final Handler handler = ProxSeeSDKManager.createProxSeeHandler();
                handler.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        INSTANCE = new ProxSeeSDKManager(context);
                        ProxSeeSDKModule module = new ProxSeeSDKModule(new ProxSeeContext(context, apiKey), handler);
                        INSTANCE.proxSeeSDKComponent = DaggerProxSeeSDKComponent.builder().proxSeeSDKModule(module).build();
                        module.setProxSeeSDKComponent(INSTANCE.proxSeeSDKComponent);
                        INSTANCE.proxSeeSDKComponent.inject(INSTANCE);
                        INSTANCE.initializeSDK();
                        Object object = INITIALIZATION_LOCK;
                        synchronized (object) {
                            INITIALIZATION_LOCK.notifyAll();
                        }
                    }
                });
                try {
                    INITIALIZATION_LOCK.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInitialized() {
        Object object = INITIALIZATION_LOCK;
        synchronized (object) {
            return INSTANCE != null;
        }
    }

    private static Handler createProxSeeHandler() {
        HandlerThread thread = new HandlerThread("io.proxsee.sdk.handlerthread");
        thread.start();
        Looper looper = thread.getLooper();
        return new Handler(looper);
    }

    private void reInitialiseSDK(final String apiKey) {
        this.proxseeSDKHandler.post(new Runnable(){

            @Override
            public void run() {
                Log.d((String)TAG, (String)("Reinitialise ProxSee SDK with Api Key " + apiKey + "..."));
                ProxSeeSDKManager.this.proxSeeContext.flushApiKey(apiKey);
                boolean hasChanged = ProxSeeSDKManager.this.saveFingerprint();
                if (hasChanged && ProxSeeSDKManager.this.isStarted()) {
                    ProxSeeSDKManager.this.stopSDK();
                    ProxSeeSDKManager.this.startSDK();
                }
            }
        });
    }

    private void initializeSDK() {
        this.saveFingerprint();
        if (this.isStarted()) {
            this.startSDK();
        }
    }

    private boolean saveFingerprint() {
        String FINGER_PRINT = "FINGER_PRINT";
        boolean hasChanged = false;
        String oldHash = this.preference.getString("FINGER_PRINT", null);
        String newHash = this.proxSeeContext.getFingerprint();
        if (oldHash != null && !newHash.equals(oldHash)) {
            hasChanged = true;
            this.appContext.sendBroadcast((Intent)new SDKReset(this.appContext));
        }
        this.preference.setString("FINGER_PRINT", newHash);
        return hasChanged;
    }

    private void startSDK() {
        this.preference.setBoolean(STARTED, true);
        this.proxseeSDKHandler.post(new Runnable(){

            @Override
            public void run() {
                Log.d((String)TAG, (String)"Starting ProxSee SDK...");
                ProxSeeSDKManager.this.realBeaconService.start();
                ProxSeeSDKManager.this.virtualBeaconService.start();
                ProxSeeSDKManager.this.permissionsMonitor.start();
                ProxSeeSDKManager.this.appContext.startService(ProxSeeSDKManager.this.mKeepAlive);
                ProxSeeSDKManager.this.appContext.sendBroadcast((Intent)new SDKStarted(ProxSeeSDKManager.this.appContext));
            }
        });
    }

    private void stopSDK() {
        this.preference.setBoolean(STARTED, false);
        this.proxseeSDKHandler.post(new Runnable(){

            @Override
            public void run() {
                Log.d((String)TAG, (String)"Stoping ProxSee SDK...");
                ProxSeeSDKManager.this.realBeaconService.stop();
                ProxSeeSDKManager.this.virtualBeaconService.stop();
                ProxSeeSDKManager.this.permissionsMonitor.stop();
                ProxSeeSDKManager.this.appContext.stopService(ProxSeeSDKManager.this.mKeepAlive);
                ProxSeeSDKManager.this.appContext.sendBroadcast((Intent)new SDKStopped(ProxSeeSDKManager.this.appContext));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = START_VALUE_LOCK;
        synchronized (object) {
            if (this.isStarted()) {
                return;
            }
            this.startSDK();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = START_VALUE_LOCK;
        synchronized (object) {
            if (!this.isStarted()) {
                return;
            }
            this.stopSDK();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStarted() {
        Object object = START_VALUE_LOCK;
        synchronized (object) {
            return this.preference.getBoolean(STARTED, true);
        }
    }

    public void updateMetadata(final HashMap<String, Object> metadata, final CompletionHandler completionHandler) {
        this.proxseeSDKHandler.post(new Runnable(){

            @Override
            public void run() {
                String lastMetadataHash;
                final Handler mainHandler = new Handler(Looper.getMainLooper());
                if (!ProxSeeSDKManager.this.isStarted()) {
                    mainHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            completionHandler.onUpdateCompleted(false, new IllegalStateException("ProxSeeSDKManager must be started!"));
                        }
                    });
                    return;
                }
                String METADATA_HASH = "METADATA_HASH";
                final String currentMetadataHash = Utils.createHash(metadata);
                if (currentMetadataHash.equals(lastMetadataHash = ProxSeeSDKManager.this.preference.getString("METADATA_HASH", null))) {
                    mainHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            completionHandler.onUpdateCompleted(true, null);
                        }
                    });
                    return;
                }
                new UpdateMetadataRequest(ProxSeeSDKManager.this.proxSeeContext, metadata).invoke(new Callback<UpdateMetadataResponse>(){

                    @Override
                    public void onSuccess(UpdateMetadataResponse response) {
                        ProxSeeSDKManager.this.preference.setString("METADATA_HASH", currentMetadataHash);
                        mainHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                completionHandler.onUpdateCompleted(true, null);
                            }
                        });
                    }

                    @Override
                    public void onError(UpdateMetadataResponse response, final Throwable e) {
                        final String Message = e == null ? "Failed to Update metadata" : e.getMessage();
                        mainHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                completionHandler.onUpdateCompleted(false, new Exception(Message, e));
                            }
                        });
                    }
                });
            }
        });
    }

    public static interface CompletionHandler {
        public void onUpdateCompleted(boolean var1, Exception var2);
    }
}

