/*
 * Decompiled with CFR 0.152.
 */
package io.proxsee.sdk.beaconsnearby;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import io.proxsee.sdk.ProxSeeContext;
import io.proxsee.sdk.beaconsnearby.BeaconNearbyNotifier;
import io.proxsee.sdk.beaconsnearby.HasSubscribedRegion;
import io.proxsee.sdk.beaconsnearby.NearbyBeacon;
import io.proxsee.sdk.entity.ProxSeeBeacon;
import io.proxsee.sdk.entity.ProxSeeBeaconRepository;
import io.proxsee.sdk.listener.BluetoothStateListener;
import io.proxsee.sdk.listener.SDKEventListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import org.altbeacon.beacon.Beacon;
import org.altbeacon.beacon.RangeNotifier;
import org.altbeacon.beacon.Region;

public class BeaconNearbyMonitor
implements RangeNotifier,
SDKEventListener,
BluetoothStateListener,
HasSubscribedRegion {
    private static final String TAG = BeaconNearbyMonitor.class.getSimpleName();
    @Inject
    Handler handler;
    @Inject
    ProxSeeContext proxSeeContext;
    @Inject
    ProxSeeBeaconRepository proxSeeBeaconRepository;
    private Collection<NearbyBeacon> currentRangingBeacons = new HashSet<NearbyBeacon>();
    private Collection<NearbyBeacon> previousRangingBeacons = new HashSet<NearbyBeacon>();
    private BeaconNearbyNotifier notifier;
    private int numberOfCycles = 0;
    private Region region;
    private Runnable endCycleRunnable;
    private Handler cycleHandler = this.createCycleHandher();

    @Override
    public void setSubscribedRegion(Region aRegion) {
        this.region = aRegion;
        if (this.region != null) {
            this.cycleHandler.post(new Runnable(){

                @Override
                public void run() {
                    List<ProxSeeBeacon> proxSeeBeacons = BeaconNearbyMonitor.this.proxSeeBeaconRepository.findAll(true, false);
                    BeaconNearbyMonitor.this.previousRangingBeacons = new HashSet();
                    for (ProxSeeBeacon proxSeeBeacon : proxSeeBeacons) {
                        BeaconNearbyMonitor.this.previousRangingBeacons.add(new NearbyBeacon(proxSeeBeacon, BeaconNearbyMonitor.this.region.getId1().toUuid()));
                    }
                }
            });
        }
    }

    private Handler createCycleHandher() {
        HandlerThread thread = new HandlerThread("io.proxsee.sdk.handlerthread");
        thread.start();
        Looper looper = thread.getLooper();
        return new Handler(looper);
    }

    public void didRangeBeaconsInRegion(final Collection<Beacon> collection, final Region aRegion) {
        this.cycleHandler.post(new Runnable(){

            @Override
            public void run() {
                if (BeaconNearbyMonitor.this.region == null || !aRegion.equals((Object)BeaconNearbyMonitor.this.region)) {
                    return;
                }
                if (BeaconNearbyMonitor.this.numberOfCycles == 0) {
                    Log.d((String)TAG, (String)String.format("Process start", new Object[0]));
                }
                if (BeaconNearbyMonitor.this.endCycleRunnable == null) {
                    Log.d((String)TAG, (String)("Start  Cycle " + BeaconNearbyMonitor.this.numberOfCycles));
                    BeaconNearbyMonitor.this.endCycleRunnable = new Runnable(){

                        @Override
                        public void run() {
                            BeaconNearbyMonitor.this.processEndOfCycle();
                            BeaconNearbyMonitor.this.endCycleRunnable = null;
                        }
                    };
                } else {
                    Log.d((String)TAG, (String)("Reset  Cycle " + BeaconNearbyMonitor.this.numberOfCycles));
                    BeaconNearbyMonitor.this.cycleHandler.removeCallbacks(BeaconNearbyMonitor.this.endCycleRunnable);
                }
                Collection pBeacons = BeaconNearbyMonitor.this.convertToNearBy(collection);
                Log.d((String)TAG, (String)String.format("Iteration region %s with beacon in range\n %s ", BeaconNearbyMonitor.this.region, TextUtils.join((CharSequence)"\n", (Iterable)pBeacons)));
                boolean doContainAll = BeaconNearbyMonitor.this.previousRangingBeacons.containsAll(pBeacons);
                HashSet oldPreviousRangingBeacons = new HashSet(BeaconNearbyMonitor.this.previousRangingBeacons);
                BeaconNearbyMonitor.this.previousRangingBeacons.removeAll(pBeacons);
                BeaconNearbyMonitor.this.previousRangingBeacons.addAll(pBeacons);
                if (!doContainAll) {
                    Log.d((String)TAG, (String)"Quick flush");
                    Log.d((String)TAG, (String)("Previous\n" + TextUtils.join((CharSequence)"\n", (Iterable)BeaconNearbyMonitor.this.previousRangingBeacons)));
                    BeaconNearbyMonitor.this.notifyChange(BeaconNearbyMonitor.this.previousRangingBeacons, oldPreviousRangingBeacons);
                }
                BeaconNearbyMonitor.this.currentRangingBeacons.removeAll(pBeacons);
                BeaconNearbyMonitor.this.currentRangingBeacons.addAll(pBeacons);
                BeaconNearbyMonitor.this.updateLastNotSeen(pBeacons, System.currentTimeMillis());
                Log.d((String)TAG, (String)("Current\n" + TextUtils.join((CharSequence)"\n", (Iterable)BeaconNearbyMonitor.this.currentRangingBeacons)));
                BeaconNearbyMonitor.this.cycleHandler.postDelayed(BeaconNearbyMonitor.this.endCycleRunnable, BeaconNearbyMonitor.this.proxSeeContext.getBluetoothScanBetweenPeriod() - 1L);
            }
        });
    }

    private Collection<NearbyBeacon> convertToNearBy(Collection<Beacon> nativeBeacons) {
        HashSet<NearbyBeacon> nearbyBeacons = new HashSet<NearbyBeacon>();
        for (Beacon b : nativeBeacons) {
            nearbyBeacons.add(new NearbyBeacon(b));
        }
        return nearbyBeacons;
    }

    private void processEndOfCycle() {
        Log.d((String)TAG, (String)("End Cycle " + this.numberOfCycles));
        if (++this.numberOfCycles <= this.proxSeeContext.getCycleExitExpireCount() - 1) {
            return;
        }
        Log.d((String)TAG, (String)String.format("Process end of Process", new Object[0]));
        if (!this.isEmpty() && this.hasCycleChanged()) {
            Log.d((String)TAG, (String)"Process End, POSTING CHANGES");
            this.notifyChange(this.currentRangingBeacons, this.previousRangingBeacons);
        } else {
            Log.d((String)TAG, (String)"Process End, NO CHANGES");
        }
        this.resetProcess();
    }

    private boolean isEmpty() {
        return this.previousRangingBeacons.isEmpty() && this.currentRangingBeacons.isEmpty();
    }

    private boolean hasCycleChanged() {
        return !this.previousRangingBeacons.containsAll(this.currentRangingBeacons) || !this.currentRangingBeacons.containsAll(this.previousRangingBeacons);
    }

    private void updateLastNotSeen(Collection<NearbyBeacon> nearbyBeacons, long now) {
        HashSet<NearbyBeacon> newCurrentRangingBeacons = new HashSet<NearbyBeacon>(this.currentRangingBeacons);
        newCurrentRangingBeacons.removeAll(nearbyBeacons);
        for (NearbyBeacon nb : newCurrentRangingBeacons) {
            if (nb.getLastTimeNotSeen() != 0L) continue;
            nb.setLastTimeNotSeen(now);
        }
        HashSet<NearbyBeacon> newPreviousRangingBeacons = new HashSet<NearbyBeacon>(this.previousRangingBeacons);
        newPreviousRangingBeacons.removeAll(nearbyBeacons);
        for (NearbyBeacon nb : newPreviousRangingBeacons) {
            if (nb.getLastTimeNotSeen() != 0L) continue;
            nb.setLastTimeNotSeen(now);
        }
    }

    private void resetProcess() {
        this.previousRangingBeacons = new HashSet<NearbyBeacon>(this.currentRangingBeacons);
        this.currentRangingBeacons = new HashSet<NearbyBeacon>();
        this.numberOfCycles = 0;
    }

    private void notifyChange(Collection<NearbyBeacon> currentRangingBeacons, Collection<NearbyBeacon> previousRangingBeacons) {
        final HashSet<NearbyBeacon> newCurrentRangingBeacons = new HashSet<NearbyBeacon>(currentRangingBeacons);
        final HashSet<NearbyBeacon> newPreviousRangingBeacons = new HashSet<NearbyBeacon>(previousRangingBeacons);
        newPreviousRangingBeacons.removeAll(currentRangingBeacons);
        if (this.notifier != null) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    Log.d((String)TAG, (String)("No Longer Visible\n" + TextUtils.join((CharSequence)"\n", (Iterable)newPreviousRangingBeacons)));
                    BeaconNearbyMonitor.this.notifier.didChangeBeaconsNearby(newCurrentRangingBeacons, newPreviousRangingBeacons);
                }
            });
        }
    }

    private void resetAll() {
        this.cycleHandler.post(new Runnable(){

            @Override
            public void run() {
                BeaconNearbyMonitor.this.previousRangingBeacons = new HashSet();
                BeaconNearbyMonitor.this.currentRangingBeacons = new HashSet();
                BeaconNearbyMonitor.this.numberOfCycles = 0;
            }
        });
    }

    public void setBeaconNearbyNotifier(BeaconNearbyNotifier notifier) {
        this.notifier = notifier;
    }

    @Override
    public void onSDKStarting() {
    }

    @Override
    public void onSDKStopping() {
        this.resetAll();
    }

    @Override
    public void onSDKReset() {
    }

    @Override
    public void onBluetoothTurnedOff() {
        this.resetAll();
    }

    @Override
    public void onBluetoothTurnedOn() {
    }
}

