/*
 * Decompiled with CFR 0.152.
 */
package io.proxsee.sdk.client.request;

import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonArrayRequest;
import io.proxsee.sdk.ProxSeeContext;
import io.proxsee.sdk.client.Callback;
import io.proxsee.sdk.client.request.AbstractProxSeeRequest;
import io.proxsee.sdk.client.request.RequestQueue;
import io.proxsee.sdk.client.response.BeaconsAroundMeResponse;
import io.proxsee.sdk.entity.ProxSeeBeacon;
import io.proxsee.sdk.misc.Utils;
import java.util.Map;
import org.json.JSONArray;

public class BeaconsAroundMeRequest
extends AbstractProxSeeRequest<BeaconsAroundMeResponse> {
    private final String PATH = "/api/beacons/active";
    private final ProxSeeContext proxSeeContext;

    public BeaconsAroundMeRequest(ProxSeeContext context) {
        this.proxSeeContext = context;
    }

    @Override
    public void invoke(final Callback<BeaconsAroundMeResponse> callback) {
        String url = this.proxSeeContext.getApiURL() + String.format("/api/beacons/active", new Object[0]);
        JsonArrayRequest request = new JsonArrayRequest(0, url, (Response.Listener)new Response.Listener<JSONArray>(){

            public void onResponse(JSONArray response) {
                ProxSeeBeacon[] proxSeeBeacons = (ProxSeeBeacon[])Utils.getGson().fromJson(response.toString(), ProxSeeBeacon[].class);
                callback.onSuccess(new BeaconsAroundMeResponse(200, proxSeeBeacons));
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                if (error.networkResponse != null) {
                    callback.onError(new BeaconsAroundMeResponse(error.networkResponse.statusCode), error.getCause());
                } else {
                    callback.onError(null, error.getCause());
                }
            }
        }){

            public Map<String, String> getHeaders() {
                return BeaconsAroundMeRequest.this.proxSeeContext.getHeaders();
            }
        };
        RequestQueue queue = RequestQueue.getInstance(this.proxSeeContext.getApplicationContext());
        queue.add((Request<?>)request);
    }
}

