/*
 * Decompiled with CFR 0.152.
 */
package io.proxsee.sdk.client.request;

import android.util.Log;
import com.android.volley.NetworkResponse;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import io.proxsee.sdk.ProxSeeContext;
import io.proxsee.sdk.client.Callback;
import io.proxsee.sdk.client.request.AbstractProxSeeRequest;
import io.proxsee.sdk.client.request.RequestQueue;
import io.proxsee.sdk.client.response.HandshakeResponse;
import io.proxsee.sdk.entity.Handshake;
import io.proxsee.sdk.misc.Utils;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class HandshakeRequest
extends AbstractProxSeeRequest<HandshakeResponse> {
    private final String PATH = "/api/device/%s/handshakes";
    private static final String TAG = HandshakeRequest.class.getSimpleName();
    private final String deviceUUID;
    private final List<Handshake> handshakes;
    private final ProxSeeContext proxSeeContext;

    public HandshakeRequest(ProxSeeContext context, List<Handshake> handshakes) {
        this.proxSeeContext = context;
        this.deviceUUID = Utils.getUniqueID(context.getApplicationContext());
        this.handshakes = handshakes;
    }

    @Override
    public void invoke(final Callback<HandshakeResponse> callback) {
        String requestBody = Utils.getGson().toJson(this.handshakes);
        String url = this.proxSeeContext.getApiURL() + String.format("/api/device/%s/handshakes", this.deviceUUID);
        JsonObjectRequest request = new JsonObjectRequest(1, url, requestBody, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                callback.onSuccess(new HandshakeResponse(200));
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                if (error.networkResponse != null) {
                    callback.onError(new HandshakeResponse(error.networkResponse.statusCode), error.getCause());
                } else {
                    Log.d((String)TAG, (String)("Handshake Volley response error :" + error));
                    callback.onError(new HandshakeResponse(500), error.getCause());
                }
            }
        }){

            public Map<String, String> getHeaders() {
                return HandshakeRequest.this.proxSeeContext.getHeaders();
            }

            protected Response<JSONObject> parseNetworkResponse(NetworkResponse response) {
                try {
                    if (response.data.length == 0) {
                        byte[] responseData = "{}".getBytes("UTF8");
                        response = new NetworkResponse(response.statusCode, responseData, response.headers, response.notModified);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                return super.parseNetworkResponse(response);
            }
        };
        RequestQueue queue = RequestQueue.getInstance(this.proxSeeContext.getApplicationContext());
        queue.add((Request<?>)request);
    }
}

