/*
 * Decompiled with CFR 0.152.
 */
package io.proxsee.sdk.misc;

import android.bluetooth.BluetoothAdapter;
import android.content.ContentResolver;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.proxsee.sdk.misc.Lazy;
import io.realm.RealmObject;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.TreeMap;

public class Utils {
    private static final String TAG = Utils.class.getName();
    private static final Lazy<Gson> gsonReference = Utils.createLazyGson();

    private static Lazy<Gson> createLazyGson() {
        return new Lazy<Gson>(new Lazy.LazyInitializer<Gson>(){

            @Override
            public Gson createObject() {
                return new GsonBuilder().serializeNulls().setExclusionStrategies(new ExclusionStrategy[]{new ExclusionStrategy(){

                    public boolean shouldSkipField(FieldAttributes f) {
                        return f.getDeclaringClass().equals(RealmObject.class);
                    }

                    public boolean shouldSkipClass(Class<?> clazz) {
                        return false;
                    }
                }}).create();
            }
        });
    }

    public static Gson getGson() {
        return gsonReference.getObject();
    }

    public static String getUniqueID(Context context) {
        return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
    }

    public static String createHash(String str) {
        String missingDependencies;
        try {
            if (str == null) {
                str = "";
            }
            byte[] raw = MessageDigest.getInstance("SHA-512").digest(str.getBytes("UTF-8"));
            byte[] base64 = Base64.encode((byte[])raw, (int)2);
            return new String(base64, "UTF-8");
        }
        catch (NoSuchAlgorithmException e) {
            Log.wtf((String)TAG, (String)"SHA-512 Algorithm is not supported", (Throwable)e);
            missingDependencies = "SHA-512";
        }
        catch (UnsupportedEncodingException e) {
            Log.wtf((String)TAG, (String)"UTF-8 encoding is not supported", (Throwable)e);
            missingDependencies = "UTF-8 encoding";
        }
        throw new RuntimeException("Cannot proceed. Missing dependencies: " + missingDependencies);
    }

    public static boolean isNetworkAvailable(Context context) {
        NetworkInfo[] netInfo;
        boolean haveConnectedWifi = false;
        boolean haveConnectedMobile = false;
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        for (NetworkInfo ni : netInfo = cm.getAllNetworkInfo()) {
            if (ni.getTypeName().equalsIgnoreCase("WIFI") && ni.isConnectedOrConnecting()) {
                haveConnectedWifi = true;
            }
            if (!ni.getTypeName().equalsIgnoreCase("MOBILE") || !ni.isConnectedOrConnecting()) continue;
            haveConnectedMobile = true;
        }
        return haveConnectedWifi || haveConnectedMobile;
    }

    public static boolean isAndroidOsCompatible() {
        if (Build.VERSION.SDK_INT < 18) {
            Log.e((String)TAG, (String)"ProxSee SDK requires Android 4.3 and up");
            return false;
        }
        return true;
    }

    public static boolean isLocationEnabled(Context context) {
        int locationMode = 0;
        if (Build.VERSION.SDK_INT >= 19) {
            try {
                locationMode = Settings.Secure.getInt((ContentResolver)context.getContentResolver(), (String)"location_mode");
            }
            catch (Settings.SettingNotFoundException e) {
                e.printStackTrace();
            }
            return locationMode != 0;
        }
        String locationProviders = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"location_providers_allowed");
        return !TextUtils.isEmpty((CharSequence)locationProviders);
    }

    public static boolean isBluetoothAdapterOn() {
        BluetoothAdapter mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (mBluetoothAdapter == null) {
            return false;
        }
        return mBluetoothAdapter.isEnabled();
    }

    public static String createHash(Map<String, Object> metadata) {
        TreeMap sortedMap = metadata == null ? new TreeMap() : new TreeMap<String, Object>(metadata);
        return Utils.createHash(Utils.getGson().toJson(sortedMap));
    }
}

