/*
 * Decompiled with CFR 0.152.
 */
package io.proxsee.sdk.permissions;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.util.Log;
import io.proxsee.sdk.ProxSeePermissionManager;

public class PermissionsMonitor {
    public static final String ACTION_PROXSEE_PERMISSIONS_CHANGED = "io.proxsee.sdk.permissions_changed_actions";
    public static final String EXTRA_STATE = "EXTRA_STATE";
    public static final long REPEAT_AFTER = 30000L;
    private static final String TAG = PermissionsMonitor.class.getSimpleName();
    private Context context;
    private boolean value;
    private Runnable repeatRunnable;
    private ProxSeePermissionManager permissionManager;
    private Handler handler;

    public PermissionsMonitor(Context context, ProxSeePermissionManager permissionManager, Handler handler) {
        this.context = context;
        this.permissionManager = permissionManager;
        this.value = this.permissionManager.isPermissionGranted(context);
        this.handler = handler;
    }

    public void start() {
        if (this.repeatRunnable == null) {
            this.repeatRunnable = new Runnable(){

                @Override
                public void run() {
                    PermissionsMonitor.this.evaluate();
                }
            };
            this.evaluate();
        }
    }

    public void stop() {
        if (this.repeatRunnable != null) {
            this.handler.removeCallbacks(this.repeatRunnable);
        }
    }

    private void evaluate() {
        boolean tempValue = this.permissionManager.isPermissionGranted(this.context);
        if (tempValue != this.value) {
            this.value = tempValue;
            Intent intent = new Intent(ACTION_PROXSEE_PERMISSIONS_CHANGED);
            intent.setPackage(this.context.getPackageName());
            intent.putExtra(EXTRA_STATE, this.value);
            Log.d((String)TAG, (String)("About to broadcast permission value change to " + this.value));
            this.context.sendBroadcast(intent);
        }
        this.repeat();
    }

    private void repeat() {
        if (this.repeatRunnable != null) {
            this.handler.postDelayed(this.repeatRunnable, 30000L);
        }
    }
}

