/*
 * Decompiled with CFR 0.152.
 */
package io.proxsee.sdk;

import android.content.Context;
import android.content.SharedPreferences;
import android.location.Location;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import android.util.Log;
import io.proxsee.sdk.ProxSeeBeaconHandler;
import io.proxsee.sdk.ProxSeeContext;
import io.proxsee.sdk.beaconsnearby.BeaconNearbyNotifier;
import io.proxsee.sdk.beaconsnearby.NearbyBeacon;
import io.proxsee.sdk.client.request.BeaconsAroundMeBucketRequest;
import io.proxsee.sdk.client.request.BeaconsAroundMeRequest;
import io.proxsee.sdk.client.request.ProxSeeRequest;
import io.proxsee.sdk.client.response.BeaconsAroundMeResponse;
import io.proxsee.sdk.entity.ProxSeeBeacon;
import io.proxsee.sdk.entity.ProxSeeBeaconRepository;
import io.proxsee.sdk.listener.ConnectionStateListener;
import io.proxsee.sdk.model.ProxseeBeaconsNearByResult;
import io.proxsee.sdk.virtual.LocationMonitorListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

public class ProxSeeBeaconMonitor
implements BeaconNearbyNotifier,
ConnectionStateListener,
LocationMonitorListener {
    private static final String TAG = ProxSeeBeaconMonitor.class.getSimpleName();
    private static final String PROXSEE_BEACONS_LAST_TIME_SEEN = "PROXSEE_BEACONS_LAST_TIME_SEEN";
    @Inject
    ProxSeeBeaconRepository proxSeeBeaconRepository;
    @Inject
    ProxSeeBeaconHandler beaconHandler;
    @Inject
    ProxSeeContext proxSeeContext;
    private long lastTimeSeen;

    public ProxSeeBeaconMonitor(ProxSeeContext proxSeeContext) {
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)proxSeeContext.getApplicationContext());
        this.lastTimeSeen = prefs.getLong(PROXSEE_BEACONS_LAST_TIME_SEEN, 0L);
    }

    @Override
    public void onDataConnectionAvailable() {
        Log.d((String)TAG, (String)"data connection available");
    }

    @Override
    public void onDataConnectionLost() {
        Log.d((String)TAG, (String)"data connection unavailable!");
    }

    @Override
    public void didUpdateLocation(Location location) {
        List<ProxSeeBeacon> previousRealBeaconsInRange = this.proxSeeBeaconRepository.findAll(true, false);
        List<ProxSeeBeacon> previousAllBeaconsInRange = this.proxSeeBeaconRepository.findAll(true);
        Collection<ProxSeeBeacon> currentBeaconsInRange = this.findProxSeeBeaconsInRange(location);
        currentBeaconsInRange.addAll(previousRealBeaconsInRange);
        this.processBeaconsEvent(previousAllBeaconsInRange, currentBeaconsInRange);
    }

    @Override
    public void didChangeBeaconsNearby(Collection<NearbyBeacon> currentNearbyBeacons, Collection<NearbyBeacon> noLongerVisibleBeacons) {
        List<ProxSeeBeacon> previousVirtualBeaconsInRange = this.proxSeeBeaconRepository.findAll(true, true);
        List<ProxSeeBeacon> previousAllBeaconsInRange = this.proxSeeBeaconRepository.findAll(true);
        Collection<ProxSeeBeacon> convertedBeacons = this.convertToProxSeeBeacons((Collection<NearbyBeacon>)(currentNearbyBeacons.isEmpty() ? Collections.EMPTY_LIST : currentNearbyBeacons));
        Collection<ProxSeeBeacon> currentBeaconsInRange = this.populateProxSeeBeaconsInRange(convertedBeacons);
        currentBeaconsInRange.addAll(previousVirtualBeaconsInRange);
        this.populateLastExitTime(previousAllBeaconsInRange, noLongerVisibleBeacons);
        this.processBeaconsEvent(previousAllBeaconsInRange, currentBeaconsInRange);
    }

    private void populateLastExitTime(Collection<ProxSeeBeacon> proxSeeBeacons, Collection<NearbyBeacon> noLongerVisibleBeacons) {
        Collection<ProxSeeBeacon> convertedBeacons = this.convertToProxSeeBeacons((Collection<NearbyBeacon>)(noLongerVisibleBeacons.isEmpty() ? Collections.EMPTY_LIST : noLongerVisibleBeacons));
        Log.d((String)TAG, (String)("Before populating\n" + TextUtils.join((CharSequence)"\n", proxSeeBeacons)));
        block0: for (ProxSeeBeacon previousBeacon : convertedBeacons) {
            for (ProxSeeBeacon proxSeeBeacon : proxSeeBeacons) {
                if (!proxSeeBeacon.equals(previousBeacon)) continue;
                proxSeeBeacon.setExitAt(previousBeacon.getExitAt());
                continue block0;
            }
        }
        Log.d((String)TAG, (String)("After populating\n" + TextUtils.join((CharSequence)"\n", proxSeeBeacons)));
    }

    private void processBeaconsEvent(Collection<ProxSeeBeacon> previousBeaconsInRange, Collection<ProxSeeBeacon> currentBeaconsInRange) {
        ProxseeBeaconsNearByResult result = new ProxseeBeaconsNearByResult(currentBeaconsInRange, previousBeaconsInRange);
        Collection<ProxSeeBeacon> checkInBeacons = result.getAddedBeacons();
        Collection<ProxSeeBeacon> checkOutBeacons = result.getRemovedBeacons();
        this.updateProxseeBeacon(checkOutBeacons, false);
        this.proxSeeBeaconRepository.addOrUpdate(checkOutBeacons);
        this.updateProxseeBeacon(currentBeaconsInRange, true);
        this.proxSeeBeaconRepository.addOrUpdate(currentBeaconsInRange);
        if (!result.hasBeaconsChanged() && !result.hasTagsChanged()) {
            Log.d((String)TAG, (String)String.format("BEACON STATE NOT CHANGED", new Object[0]));
            return;
        }
        this.beaconHandler.checkOut(checkOutBeacons);
        this.beaconHandler.checkIn(checkInBeacons);
        this.beaconHandler.processTagChanges(result);
    }

    private Collection<ProxSeeBeacon> findProxSeeBeaconsInRange(Location location) {
        if (this.hasTimedOut()) {
            this.fetchBeacons();
        }
        List<ProxSeeBeacon> locationBeacons = this.proxSeeBeaconRepository.findAllWithVirtualFlag(true);
        ArrayList<ProxSeeBeacon> proxSeeBeacons = new ArrayList<ProxSeeBeacon>();
        for (ProxSeeBeacon beacon : locationBeacons) {
            if (!beacon.isGeofence() || !beacon.containsLocation(location)) continue;
            proxSeeBeacons.add(beacon);
        }
        return proxSeeBeacons;
    }

    private Collection<ProxSeeBeacon> convertToProxSeeBeacons(Collection<NearbyBeacon> altBeacons) {
        ArrayList<ProxSeeBeacon> proxSeeBeacons = new ArrayList<ProxSeeBeacon>();
        for (NearbyBeacon beacon : altBeacons) {
            ProxSeeBeacon proxSeeBeacon = new ProxSeeBeacon(beacon);
            proxSeeBeacons.add(proxSeeBeacon);
        }
        return proxSeeBeacons;
    }

    private void updateProxseeBeacon(Collection<ProxSeeBeacon> proxSeeBeacons, boolean nearBy) {
        for (ProxSeeBeacon beacon : proxSeeBeacons) {
            beacon.setNearby(nearBy);
        }
    }

    private Collection<ProxSeeBeacon> populateProxSeeBeaconsInRange(Collection<ProxSeeBeacon> beaconsAround) {
        boolean requestExecutedSuccessfully = false;
        boolean requestExecuted = false;
        if (this.hasTimedOut()) {
            requestExecuted = true;
            requestExecutedSuccessfully = this.fetchBeacons();
        }
        List<ProxSeeBeacon> allBeacons = this.proxSeeBeaconRepository.findAllWithVirtualFlag(false);
        ArrayList<ProxSeeBeacon> proxSeeBeacons = new ArrayList<ProxSeeBeacon>();
        for (ProxSeeBeacon beacon : beaconsAround) {
            ProxSeeBeacon proxSeeBeacon = beacon.findMatch(allBeacons);
            if (proxSeeBeacon == null) {
                proxSeeBeacon = new ProxSeeBeacon(beacon);
                if (requestExecuted) {
                    proxSeeBeacon.setBlacklisted(requestExecutedSuccessfully);
                } else {
                    requestExecuted = true;
                    requestExecutedSuccessfully = this.fetchBeacons();
                    allBeacons = this.proxSeeBeaconRepository.findAllWithVirtualFlag(false);
                    proxSeeBeacon = beacon.findMatch(allBeacons);
                    if (proxSeeBeacon == null) {
                        proxSeeBeacon = new ProxSeeBeacon(beacon);
                        proxSeeBeacon.setBlacklisted(requestExecutedSuccessfully);
                    }
                }
            }
            proxSeeBeacon.setRssi(beacon.getRssi());
            proxSeeBeacons.add(proxSeeBeacon);
        }
        return proxSeeBeacons;
    }

    private Collection<ProxSeeBeacon> substract(Collection<ProxSeeBeacon> a, Collection<ProxSeeBeacon> b) {
        ArrayList<ProxSeeBeacon> col = new ArrayList<ProxSeeBeacon>();
        col.addAll(a);
        col.removeAll(b);
        return col;
    }

    private boolean hasTimedOut() {
        return this.lastTimeSeen == 0L || this.lastTimeSeen < System.currentTimeMillis() - this.proxSeeContext.getCacheExpiry();
    }

    private ProxSeeRequest.RequestResult<BeaconsAroundMeResponse> fetchRedirectedURL(BeaconsAroundMeResponse response) {
        int status;
        if (response != null && response.getNetworkResponse() != null && (301 == (status = response.getStatus()) || status == 302 || status == 303)) {
            String location = (String)response.getNetworkResponse().headers.get("Location");
            Log.d((String)TAG, (String)("redirecting:" + location));
            if (location != null) {
                return new BeaconsAroundMeBucketRequest(this.proxSeeContext, location).invokeSync();
            }
        }
        return null;
    }

    private boolean fetchBeacons() {
        ProxSeeRequest.RequestResult<Object> result = new BeaconsAroundMeRequest(this.proxSeeContext).invokeSync();
        BeaconsAroundMeResponse response = (BeaconsAroundMeResponse)result.getResponse();
        Log.d((String)TAG, (String)"Fetching beacons:");
        if (result.isHasError()) {
            result = this.fetchRedirectedURL(response);
            if (result == null || result.isHasError()) {
                Log.d((String)TAG, (String)"redirecting error");
                return false;
            }
            response = (BeaconsAroundMeResponse)result.getResponse();
            Log.d((String)TAG, (String)"redirecting success");
        }
        ArrayList<Object> fetched = new ArrayList<Object>(Arrays.asList((Object[])response.getBody()));
        this.proxSeeBeaconRepository.deleteAll();
        this.proxSeeBeaconRepository.addOrUpdate(fetched);
        this.updateLastTimeSeen(System.currentTimeMillis());
        return true;
    }

    public void updateLastTimeSeen(long lastTimeSeen) {
        this.lastTimeSeen = lastTimeSeen;
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)this.proxSeeContext.getApplicationContext());
        SharedPreferences.Editor editor = prefs.edit();
        editor.putLong(PROXSEE_BEACONS_LAST_TIME_SEEN, this.lastTimeSeen);
        editor.commit();
    }

    public long getLastTimeSeen() {
        return this.lastTimeSeen;
    }

    public void reset() {
        this.proxSeeBeaconRepository.deleteAll();
        this.updateLastTimeSeen(0L);
    }
}

