/*
 * Decompiled with CFR 0.152.
 */
package io.proxsee.sdk;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.util.Log;
import io.proxsee.sdk.R;
import java.util.HashMap;

public class ProxSeeContext {
    private static final String FILENAME = "proxseesdk_settings";
    public static final String TAG = ProxSeeContext.class.getSimpleName();
    public static final String DEFAULT_IBEACONS_LAYOUT = "m:2-3=0215,i:4-19,i:20-21,i:22-23,p:24-24";
    public static final String DEFAULT_BASE_URL = "https://app.proxsee.io";
    public static final long DEFAULT_BLUETOOTH_SCAN_PERIOD = 1100L;
    public static final long DEFAULT_BLUETOOTH_SCAN_BETWEEN_PERIOD = 10000L;
    public static final int DEFAULT_CYCLE_EXIT_EXPIRE_COUNT = 6;
    public static final long DEFAULT_CACHE_EXPIRY = 10800000L;
    public static final int DEFAULT_MAXIMUM_OFFLINE_HANDSHAKE = 500;
    private String apiKey;
    private final String apiURL;
    private final String version;
    private final long bluetoothScanPeriod;
    private final long bluetoothScanBetweenPeriod;
    private final String beaconLayout;
    private final int cycleExitExpireCount;
    private final long cacheExpiry;
    private final int maxOfflineHandshake;
    private Context context;
    SharedPreferences securePreference;
    SharedPreferences normalPreference;
    public static final String OLD_BLUETOOTH_SCAN_PERIOD_KEY = "BLUETOOTH_SCAN_PERIOD_KEY";
    public static final String OLD_BLUETOOTH_SCAN_BETWEEN_PERIOD_KEY = "BLUETOOTH_SCAN_BETWEEN_PERIOD_KEY";
    public static final String OLD_CYCLE_EXIT_EXPIRE_COUNT_KEY = "CYCLE_EXIT_EXPIRE_COUNT_KEY";
    public static final String OLD_CACHE_EXPIRY_KEY = "CACHE_EXPIRY_KEY";

    public ProxSeeContext(Context context, String apiKey) {
        this.context = context;
        this.normalPreference = PreferenceManager.getDefaultSharedPreferences((Context)context);
        this.securePreference = context.getSharedPreferences(FILENAME, 0);
        this.apiKey = apiKey;
        this.version = "2.4.3";
        this.beaconLayout = DEFAULT_IBEACONS_LAYOUT;
        this.apiURL = this.normalPreference.getString(context.getString(R.string.proxsee_url_key), DEFAULT_BASE_URL);
        this.bluetoothScanPeriod = this.normalPreference.getLong(context.getString(R.string.proxsee_bluetooth_scan_period_key), 1100L);
        this.bluetoothScanBetweenPeriod = this.normalPreference.getLong(context.getString(R.string.proxsee_bluetooth_scan_between_period_key), 10000L);
        this.cycleExitExpireCount = this.normalPreference.getInt(context.getString(R.string.proxsee_cycle_exit_expiry_count_key), 6);
        this.cacheExpiry = this.normalPreference.getLong(context.getString(R.string.proxsee_cache_expiry_key), 10800000L);
        this.maxOfflineHandshake = this.normalPreference.getInt(context.getString(R.string.proxsee_max_offline_handshake_key), 500);
        SharedPreferences.Editor editor = this.normalPreference.edit();
        editor.putLong(OLD_BLUETOOTH_SCAN_PERIOD_KEY, 1100L);
        editor.putLong(OLD_BLUETOOTH_SCAN_BETWEEN_PERIOD_KEY, 10000L);
        editor.putInt(OLD_CYCLE_EXIT_EXPIRE_COUNT_KEY, 6);
        editor.putLong(OLD_CACHE_EXPIRY_KEY, 10800000L);
        editor.commit();
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getApiURL() {
        return this.apiURL;
    }

    public int getMaxOfflineHandshake() {
        return this.maxOfflineHandshake;
    }

    public Context getApplicationContext() {
        return this.context;
    }

    public HashMap<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + this.apiKey);
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        headers.put("Accept-Encoding", "UTF-8");
        headers.put("X-ProxSee-SDKPlatform", "android");
        headers.put("X-ProxSee-SDKVersion", this.version);
        return headers;
    }

    public void flushApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public long getBluetoothScanPeriod() {
        return this.bluetoothScanPeriod;
    }

    public long getBluetoothScanBetweenPeriod() {
        return this.bluetoothScanBetweenPeriod;
    }

    public int getCycleExitExpireCount() {
        return this.cycleExitExpireCount;
    }

    public long getCacheExpiry() {
        return this.cacheExpiry;
    }

    public String getBeaconLayout() {
        return this.beaconLayout;
    }

    public String getDeviceId() {
        return this.securePreference.getString(this.context.getString(R.string.proxsee_device_id_key), null);
    }

    public void saveDeviceId(String id) {
        String key = this.context.getString(R.string.proxsee_device_id_key);
        if (this.securePreference.getString(key, null) != null) {
            Log.d((String)TAG, (String)"Device ID already registered nothing saved");
        } else {
            Log.d((String)TAG, (String)("Saving Device ID " + id));
            SharedPreferences.Editor editor = this.securePreference.edit();
            editor.putString(key, id);
            editor.commit();
        }
    }

    public String getFingerPrint() {
        return this.securePreference.getString(this.context.getString(R.string.proxsee_finger_print_key), null);
    }

    public void setFingerPrint(String fingerPrint) {
        SharedPreferences.Editor editor = this.securePreference.edit();
        editor.putString(this.context.getString(R.string.proxsee_finger_print_key), fingerPrint);
        editor.commit();
    }

    public boolean isSDKStarted() {
        return this.securePreference.getBoolean(this.context.getString(R.string.proxsee_sdk_state_key), false);
    }

    public void setSDKStarted(boolean SDKStarted2) {
        SharedPreferences.Editor editor = this.securePreference.edit();
        editor.putBoolean(this.context.getString(R.string.proxsee_sdk_state_key), SDKStarted2);
        editor.commit();
    }

    public String getMedataDataHash() {
        return this.securePreference.getString(this.context.getString(R.string.proxsee_metatadata_hash_key), null);
    }

    public void setMetaDataHash(String hash) {
        SharedPreferences.Editor editor = this.securePreference.edit();
        editor.putString(this.context.getString(R.string.proxsee_metatadata_hash_key), hash);
        editor.commit();
    }
}

