/*
 * Decompiled with CFR 0.152.
 */
package io.proxsee.sdk.client.request;

import android.location.Location;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonArrayRequest;
import io.proxsee.sdk.ProxSeeContext;
import io.proxsee.sdk.client.Callback;
import io.proxsee.sdk.client.request.AbstractProxSeeRequest;
import io.proxsee.sdk.client.request.RequestQueue;
import io.proxsee.sdk.client.response.BeaconsAroundMeResponse;
import io.proxsee.sdk.entity.ProxSeeBeacon;
import io.proxsee.sdk.misc.Utils;
import java.util.Map;
import org.json.JSONArray;

public class BeaconsAroundMeByLocationRequest
extends AbstractProxSeeRequest<BeaconsAroundMeResponse> {
    private final String PATH = "/api/beacons/around/place/%s/%s/";
    private final ProxSeeContext proxSeeContext;
    private final Location location;
    private final int radius;

    public BeaconsAroundMeByLocationRequest(ProxSeeContext context, Location location, int radius) {
        this.location = location;
        this.radius = radius;
        this.proxSeeContext = context;
    }

    @Override
    public void invoke(final Callback<BeaconsAroundMeResponse> callback) {
        String url = this.proxSeeContext.getApiURL() + String.format("/api/beacons/around/place/%s/%s/", this.location.getLatitude(), this.location.getLongitude());
        url = url + String.format("?radius=%d", this.radius);
        JsonArrayRequest request = new JsonArrayRequest(0, url, (Response.Listener)new Response.Listener<JSONArray>(){

            public void onResponse(JSONArray response) {
                ProxSeeBeacon[] proxSeeBeacons = (ProxSeeBeacon[])Utils.getGson().fromJson(response.toString(), ProxSeeBeacon[].class);
                callback.onSuccess(new BeaconsAroundMeResponse(200, null, proxSeeBeacons));
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                if (error.networkResponse != null) {
                    callback.onError(new BeaconsAroundMeResponse(error.networkResponse.statusCode, error.networkResponse), error.getCause());
                } else {
                    callback.onError(null, error.getCause());
                }
            }
        }){

            public Map<String, String> getHeaders() {
                return BeaconsAroundMeByLocationRequest.this.proxSeeContext.getHeaders();
            }
        };
        RequestQueue queue = RequestQueue.getInstance(this.proxSeeContext.getApplicationContext());
        queue.add((Request<?>)request);
    }
}

