/*
 * Decompiled with CFR 0.152.
 */
package io.proxsee.sdk.client.request;

import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import io.proxsee.sdk.ProxSeeContext;
import io.proxsee.sdk.client.Callback;
import io.proxsee.sdk.client.request.AbstractProxSeeRequest;
import io.proxsee.sdk.client.request.RequestQueue;
import io.proxsee.sdk.client.response.CheckInResponse;
import java.util.Date;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class CheckInRequest
extends AbstractProxSeeRequest<CheckInResponse> {
    private final String PATH = "/api/device/%s/check-in";
    private final int major;
    private final int minor;
    private final Date at;
    private final String deviceUUID;
    private final ProxSeeContext proxSeeContext;

    public CheckInRequest(ProxSeeContext context, int beaconMajor, int beaconMinor) {
        this(context, beaconMajor, beaconMinor, new Date());
    }

    public CheckInRequest(ProxSeeContext context, int beaconMajor, int beaconMinor, Date at) {
        this.deviceUUID = context.getDeviceId();
        this.major = beaconMajor;
        this.minor = beaconMinor;
        this.at = at;
        this.proxSeeContext = context;
    }

    @Override
    public void invoke(final Callback<CheckInResponse> callback) {
        JSONObject requestBody = new JSONObject();
        try {
            requestBody.put("major", this.major);
            requestBody.put("minor", this.minor);
            requestBody.put("at", this.at.getTime());
        }
        catch (JSONException e) {
            callback.onError(null, e);
            return;
        }
        String url = this.proxSeeContext.getApiURL() + String.format("/api/device/%s/check-in", this.deviceUUID);
        JsonObjectRequest request = new JsonObjectRequest(1, url, requestBody, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                callback.onSuccess(new CheckInResponse(200));
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                if (error.networkResponse != null) {
                    callback.onError(new CheckInResponse(error.networkResponse.statusCode), error.getCause());
                } else {
                    callback.onError(null, error.getCause());
                }
            }
        }){

            public Map<String, String> getHeaders() {
                return CheckInRequest.this.proxSeeContext.getHeaders();
            }
        };
        RequestQueue queue = RequestQueue.getInstance(this.proxSeeContext.getApplicationContext());
        queue.add((Request<?>)request);
    }
}

