/*
 * Decompiled with CFR 0.152.
 */
package io.proxsee.sdk.client.request;

import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import io.proxsee.sdk.ProxSeeContext;
import io.proxsee.sdk.client.Callback;
import io.proxsee.sdk.client.request.AbstractProxSeeRequest;
import io.proxsee.sdk.client.request.RequestQueue;
import io.proxsee.sdk.client.response.RegisterDeviceResponse;
import io.proxsee.sdk.misc.Utils;
import java.util.Map;
import org.json.JSONObject;

public class RegisterDeviceRequest
extends AbstractProxSeeRequest<RegisterDeviceResponse> {
    private final String PATH = "/api/device/uuid";
    private final ProxSeeContext proxSeeContext;

    public RegisterDeviceRequest(ProxSeeContext context) {
        this.proxSeeContext = context;
    }

    @Override
    public void invoke(final Callback<RegisterDeviceResponse> callback) {
        String url = this.proxSeeContext.getApiURL() + "/api/device/uuid";
        JsonObjectRequest request = new JsonObjectRequest(0, url, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                RegisterDeviceResponse.UUIDDevice device = (RegisterDeviceResponse.UUIDDevice)Utils.getGson().fromJson(response.toString(), RegisterDeviceResponse.UUIDDevice.class);
                callback.onSuccess(new RegisterDeviceResponse(200, device));
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                if (error.networkResponse != null) {
                    callback.onError(new RegisterDeviceResponse(error.networkResponse.statusCode), error.getCause());
                } else {
                    callback.onError(null, error.getCause());
                }
            }
        }){

            public Map<String, String> getHeaders() {
                return RegisterDeviceRequest.this.proxSeeContext.getHeaders();
            }
        };
        RequestQueue queue = RequestQueue.getInstance(this.proxSeeContext.getApplicationContext());
        queue.add((Request<?>)request);
    }
}

