/*
 * Decompiled with CFR 0.152.
 */
package io.proxsee.sdk.client.request;

import com.android.volley.NetworkResponse;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.proxsee.sdk.ProxSeeContext;
import io.proxsee.sdk.client.Callback;
import io.proxsee.sdk.client.request.AbstractProxSeeRequest;
import io.proxsee.sdk.client.request.RequestQueue;
import io.proxsee.sdk.client.response.UpdateMetadataResponse;
import io.proxsee.sdk.misc.Utils;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.json.JSONObject;

public class UpdateMetadataRequest
extends AbstractProxSeeRequest<UpdateMetadataResponse> {
    private final String PATH = "/api/device/%s/metadata";
    private final String deviceUUID;
    private final ProxSeeContext proxSeeContext;
    private final Map<String, Object> data;

    public UpdateMetadataRequest(ProxSeeContext context, Map<String, Object> data) {
        this.proxSeeContext = context;
        this.deviceUUID = context.getDeviceId();
        this.data = data;
    }

    @Override
    public void invoke(final Callback<UpdateMetadataResponse> callback) {
        String url = this.proxSeeContext.getApiURL() + String.format("/api/device/%s/metadata", this.deviceUUID);
        JsonObject jsonObject = new JsonObject();
        try {
            jsonObject.add("metadata", Utils.getGson().toJsonTree(this.data));
        }
        catch (JsonParseException e) {
            callback.onError(null, e.getCause());
        }
        JsonObjectRequest request = new JsonObjectRequest(2, url, jsonObject.toString(), (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                callback.onSuccess(new UpdateMetadataResponse(200));
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                if (error.networkResponse != null) {
                    callback.onError(new UpdateMetadataResponse(error.networkResponse.statusCode), error.getCause());
                } else {
                    callback.onError(null, error.getCause());
                }
            }
        }){

            public Map<String, String> getHeaders() {
                return UpdateMetadataRequest.this.proxSeeContext.getHeaders();
            }

            protected Response<JSONObject> parseNetworkResponse(NetworkResponse response) {
                try {
                    if (response.data.length == 0) {
                        byte[] responseData = "{}".getBytes("UTF8");
                        response = new NetworkResponse(response.statusCode, responseData, response.headers, response.notModified);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                return super.parseNetworkResponse(response);
            }
        };
        RequestQueue queue = RequestQueue.getInstance(this.proxSeeContext.getApplicationContext());
        queue.add((Request<?>)request);
    }
}

