/*
 * Decompiled with CFR 0.152.
 */
package io.proxsee.sdk;

import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.RemoteException;
import android.util.Log;
import io.proxsee.sdk.ProxSeeContext;
import io.proxsee.sdk.beaconsnearby.HasSubscribedRegion;
import io.proxsee.sdk.client.request.MonitoringRegionsRequest;
import io.proxsee.sdk.client.request.ProxSeeRequest;
import io.proxsee.sdk.client.response.MonitoringRegionsResponse;
import io.proxsee.sdk.entity.MonitoringRegion;
import io.proxsee.sdk.entity.MonitoringRegionRepository;
import io.proxsee.sdk.listener.ConnectionStateListener;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.altbeacon.beacon.BeaconConsumer;
import org.altbeacon.beacon.BeaconManager;
import org.altbeacon.beacon.Identifier;
import org.altbeacon.beacon.Region;

public class ProxSeeBeaconConsumer
implements BeaconConsumer,
ConnectionStateListener {
    private static final String TAG = ProxSeeBeaconConsumer.class.getSimpleName();
    @Inject
    BeaconManager beaconManager;
    @Inject
    ProxSeeContext proxSeeContext;
    @Inject
    Context context;
    @Inject
    MonitoringRegionRepository monitoringRegionRepository;
    @Inject
    Handler proxseeSDKHandler;
    @Inject
    HasSubscribedRegion hasSubscribedRegion;
    private boolean startedMonitoring;

    @Override
    public void onDataConnectionAvailable() {
        this.proxseeSDKHandler.post(new Runnable(){

            @Override
            public void run() {
                if (!ProxSeeBeaconConsumer.this.startedMonitoring) {
                    ProxSeeBeaconConsumer.this.onBeaconServiceConnect();
                }
            }
        });
    }

    @Override
    public void onDataConnectionLost() {
        this.proxseeSDKHandler.post(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    public void onBeaconServiceConnect() {
        this.proxseeSDKHandler.post(new Runnable(){

            @Override
            public void run() {
                if (ProxSeeBeaconConsumer.this.startedMonitoring) {
                    return;
                }
                List<Object> regions = ProxSeeBeaconConsumer.this.monitoringRegionRepository.findAll();
                if (regions == null || regions.size() < 1) {
                    ProxSeeRequest.RequestResult result = new MonitoringRegionsRequest(ProxSeeBeaconConsumer.this.proxSeeContext).invokeSync();
                    if (result.isHasError()) {
                        Log.e((String)TAG, (String)"Error fetching regions", (Throwable)result.getThrowable());
                    } else {
                        regions = Arrays.asList((Object[])((MonitoringRegionsResponse)result.getResponse()).getBody());
                        ProxSeeBeaconConsumer.this.monitoringRegionRepository.deleteAll();
                        ProxSeeBeaconConsumer.this.monitoringRegionRepository.addOrUpdate(regions);
                    }
                }
                ProxSeeBeaconConsumer.this.startMonitoring(regions);
            }
        });
    }

    private void startMonitoring(List<MonitoringRegion> regions) {
        for (MonitoringRegion cur : regions) {
            Identifier uuid = Identifier.parse((String)cur.getUuid());
            Identifier major = Identifier.fromInt((int)cur.getMajor());
            Region altBeaconRegion = new Region(uuid + "", uuid, null, null);
            this.hasSubscribedRegion.setSubscribedRegion(altBeaconRegion);
            try {
                this.beaconManager.stopRangingBeaconsInRegion(altBeaconRegion);
                this.beaconManager.startRangingBeaconsInRegion(altBeaconRegion);
                this.startedMonitoring = true;
                Log.d((String)TAG, (String)("Started to monitor beacons with UUID: " + uuid));
                break;
            }
            catch (RemoteException e) {
                Log.e((String)TAG, (String)"Failed to start region monitoring", (Throwable)e);
            }
        }
    }

    public Context getApplicationContext() {
        return this.context;
    }

    public void unbindService(ServiceConnection serviceConnection) {
        this.startedMonitoring = false;
        this.context.unbindService(serviceConnection);
    }

    public boolean bindService(Intent intent, ServiceConnection serviceConnection, int i) {
        return this.context.bindService(intent, serviceConnection, i);
    }
}

