/*
 * Decompiled with CFR 0.152.
 */
package io.proxsee.sdk;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import io.proxsee.sdk.ProxSeeContext;
import io.proxsee.sdk.ProxSeeOfflineHandler;
import io.proxsee.sdk.broadcast.ProxSeeBroadcaster;
import io.proxsee.sdk.entity.ProxSeeBeacon;
import io.proxsee.sdk.listener.SDKEventListener;
import io.proxsee.sdk.model.BeaconNotificationObject;
import io.proxsee.sdk.model.ProxseeBeaconsNearByResult;
import io.proxsee.sdk.model.TagsChangedSet;
import java.util.Collection;
import java.util.Date;
import javax.inject.Inject;

public class ProxSeeBeaconHandler
implements SDKEventListener {
    private static final String LAST_SEEN_KEY = "LAST_SEEN_KEY";
    @Inject
    ProxSeeContext proxSeeContext;
    @Inject
    ProxSeeOfflineHandler proxSeeOfflineHandler;
    @Inject
    ProxSeeBroadcaster broadcaster;

    public void checkIn(Collection<ProxSeeBeacon> beacons) {
        if (beacons.size() <= 0) {
            return;
        }
        this.proxSeeOfflineHandler.checkIn(beacons);
    }

    public void checkOut(Collection<ProxSeeBeacon> beacons) {
        if (beacons.size() <= 0) {
            return;
        }
        this.proxSeeOfflineHandler.checkOut(beacons);
    }

    public void processTagChanges(ProxseeBeaconsNearByResult result) {
        if (result.hasTagsChanged()) {
            TagsChangedSet oldTagsSet = new TagsChangedSet(result.getOldTags(), this.getLastSeen(), result.getPreviousProxseeBeacons());
            TagsChangedSet newTagsSet = new TagsChangedSet(result.getNewTags(), result.getLastSeen(), result.getCurrentProxseeBeacons());
            this.saveLastSeen(result.getLastSeen());
            BeaconNotificationObject notificationObject = new BeaconNotificationObject(oldTagsSet, newTagsSet);
            this.broadcaster.sendTagsChangeBroadCast(notificationObject);
        }
    }

    private void saveLastSeen(Date date) {
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)this.proxSeeContext.getApplicationContext());
        SharedPreferences.Editor editor = prefs.edit();
        editor.putLong(LAST_SEEN_KEY, date.getTime());
        editor.commit();
    }

    private Date getLastSeen() {
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)this.proxSeeContext.getApplicationContext());
        Long lastSeenLong = prefs.getLong(LAST_SEEN_KEY, 0L);
        return lastSeenLong == 0L ? null : new Date(lastSeenLong);
    }

    @Override
    public void onSDKStarting() {
    }

    @Override
    public void onSDKStopping() {
        this.clearLastSeen();
    }

    @Override
    public void onSDKReset() {
        this.clearLastSeen();
    }

    private void clearLastSeen() {
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)this.proxSeeContext.getApplicationContext());
        SharedPreferences.Editor editor = prefs.edit();
        editor.remove(LAST_SEEN_KEY);
        editor.commit();
    }
}

