/*
 * Decompiled with CFR 0.152.
 */
package io.proxsee.sdk.broadcastreceiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import io.proxsee.sdk.listener.PermissionsStateListener;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;

public class PermissionsBroadcastReciever {
    private final Set<PermissionsStateListener> listeners = Collections.newSetFromMap(new WeakHashMap());

    public PermissionsBroadcastReciever(Context context, Handler handler) {
        IntentFilter filter = new IntentFilter();
        filter.addAction("io.proxsee.sdk.permissions_changed_actions");
        context.registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if (PermissionsBroadcastReciever.this.listeners.isEmpty()) {
                    return;
                }
                boolean enabled = intent.getExtras().getBoolean("EXTRA_STATE");
                for (PermissionsStateListener listener : PermissionsBroadcastReciever.this.listeners) {
                    if (enabled) {
                        listener.onPermissionsEnabled();
                        continue;
                    }
                    listener.onPermissionsRevoked();
                }
            }
        }, filter, null, handler);
    }

    public void addListener(PermissionsStateListener listener) {
        this.listeners.add(listener);
    }
}

