/*
 * Decompiled with CFR 0.152.
 */
package io.proxsee.sdk.client.request;

import io.proxsee.sdk.ProxSeeContext;
import io.proxsee.sdk.client.Callback;
import io.proxsee.sdk.client.request.AbstractProxSeeRequest;
import io.proxsee.sdk.client.request.Client;
import io.proxsee.sdk.client.response.RegisterDeviceResponse;
import io.proxsee.sdk.misc.Utils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;
import okhttp3.Request;
import okhttp3.Response;

public class RegisterDeviceRequest
extends AbstractProxSeeRequest<RegisterDeviceResponse> {
    private final String PATH = "/api/device/uuid";
    private final ProxSeeContext proxSeeContext;

    public RegisterDeviceRequest(ProxSeeContext context) {
        this.proxSeeContext = context;
    }

    @Override
    public void invoke(final Callback<RegisterDeviceResponse> callback) {
        String url = this.proxSeeContext.getApiURL() + "/api/device/uuid";
        Request.Builder builder = new Request.Builder().url(url);
        HashMap<String, String> headers = this.proxSeeContext.getHeaders();
        for (Map.Entry pair : headers.entrySet()) {
            builder.addHeader((String)pair.getKey(), (String)pair.getValue());
        }
        Request request = builder.build();
        okhttp3.Callback requestCallBack = new okhttp3.Callback(){

            public void onFailure(Call call, IOException e) {
                call.cancel();
                callback.onError(new RegisterDeviceResponse(600), e);
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (response.isSuccessful()) {
                    RegisterDeviceResponse.UUIDDevice device = (RegisterDeviceResponse.UUIDDevice)Utils.getGson().fromJson(response.body().string(), RegisterDeviceResponse.UUIDDevice.class);
                    callback.onSuccess(new RegisterDeviceResponse(response.code(), device));
                } else {
                    callback.onError(new RegisterDeviceResponse(response.code()), null);
                }
            }
        };
        Client.getInstance(this.proxSeeContext.getApplicationContext()).execute(request, requestCallBack);
    }
}

