/*
 * Decompiled with CFR 0.152.
 */
package io.proxsee.sdk.model;

import io.proxsee.sdk.entity.ProxSeeBeacon;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class ProxseeBeaconsNearByResult {
    private final Collection<ProxSeeBeacon> currentProxseeBeacons;
    private final Collection<ProxSeeBeacon> previousProxseeBeacons;
    private final Collection<ProxSeeBeacon> addedBeacons;
    private final Collection<ProxSeeBeacon> removedBeacons;
    private final Set<String> newTags;
    private final Set<String> oldTags;
    private final Date lastSeen;

    public ProxseeBeaconsNearByResult(Collection<ProxSeeBeacon> currentProxseeBeacons, Collection<ProxSeeBeacon> previousProxseeBeacons) {
        this.currentProxseeBeacons = currentProxseeBeacons;
        this.previousProxseeBeacons = previousProxseeBeacons;
        this.addedBeacons = this.substract(currentProxseeBeacons, previousProxseeBeacons);
        this.removedBeacons = this.substract(previousProxseeBeacons, currentProxseeBeacons);
        this.newTags = new HashSet<String>();
        this.oldTags = new HashSet<String>();
        for (ProxSeeBeacon newBeacon : currentProxseeBeacons) {
            this.newTags.addAll(Arrays.asList(newBeacon.getTags()));
        }
        for (ProxSeeBeacon oldBeacon : previousProxseeBeacons) {
            this.oldTags.addAll(Arrays.asList(oldBeacon.getTags()));
        }
        this.lastSeen = new Date();
    }

    private Collection<ProxSeeBeacon> substract(Collection<ProxSeeBeacon> a, Collection<ProxSeeBeacon> b) {
        ArrayList<ProxSeeBeacon> col = new ArrayList<ProxSeeBeacon>();
        col.addAll(a);
        col.removeAll(b);
        return col;
    }

    public Collection<ProxSeeBeacon> getCurrentProxseeBeacons() {
        return this.currentProxseeBeacons;
    }

    public Collection<ProxSeeBeacon> getPreviousProxseeBeacons() {
        return this.previousProxseeBeacons;
    }

    public Collection<ProxSeeBeacon> getAddedBeacons() {
        return this.addedBeacons;
    }

    public Collection<ProxSeeBeacon> getRemovedBeacons() {
        return this.removedBeacons;
    }

    public Set<String> getNewTags() {
        return this.newTags;
    }

    public Set<String> getOldTags() {
        return this.oldTags;
    }

    public boolean hasTagsChanged() {
        return !this.newTags.equals(this.oldTags);
    }

    public boolean hasBeaconsChanged() {
        return this.addedBeacons.size() > 0 || this.removedBeacons.size() > 0;
    }

    public Date getLastSeen() {
        return this.lastSeen;
    }
}

