/*
 * Decompiled with CFR 0.152.
 */
package io.proxsee.sdk.virtual;

import android.app.AppOpsManager;
import android.content.ContentResolver;
import android.content.Context;
import android.location.Location;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Process;
import android.provider.Settings;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.location.FusedLocationProviderApi;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import io.proxsee.sdk.ProxSeePermissionManager;
import io.proxsee.sdk.virtual.LocationMonitorListener;
import java.util.HashSet;

public class LocationMonitor
implements GoogleApiClient.OnConnectionFailedListener,
GoogleApiClient.ConnectionCallbacks,
LocationListener {
    private static final String TAG = LocationMonitor.class.getSimpleName();
    public static final String MOCK_LOCATION_PROVIDER = "MOCK_PROVIDER";
    private static final long MIN_TIME = 20000L;
    private static final long MINIMUM_CIRCLE_RADUIS = 105L;
    private static final long LOCATION_INTERVAL_TIME = 300000L;
    private static final long LOCATION_FASTEST_INTERVAL_TIME = 120000L;
    private GoogleApiClient googleApiClient;
    private FusedLocationProviderApi api;
    private HashSet<LocationMonitorListener> callBacks;
    private Location lastLocation;
    private ProxSeePermissionManager proxSeePermissionManager;
    private Context context;
    private Handler handler;

    public LocationMonitor(ProxSeePermissionManager permissionManager, Context context, Handler handler) {
        this.googleApiClient = new GoogleApiClient.Builder(context).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).addApi(LocationServices.API).build();
        this.context = context;
        this.handler = handler;
        this.callBacks = new HashSet();
        this.api = LocationServices.FusedLocationApi;
        this.proxSeePermissionManager = permissionManager;
    }

    public void disconnect() {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                if (LocationMonitor.this.googleApiClient.isConnected()) {
                    Log.d((String)TAG, (String)"Location api disconnected");
                    LocationMonitor.this.googleApiClient.disconnect();
                }
            }
        });
    }

    public void connect() {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                if (!LocationMonitor.this.googleApiClient.isConnected()) {
                    Log.d((String)TAG, (String)"Location api reconnected");
                    LocationMonitor.this.googleApiClient.connect();
                }
            }
        });
    }

    public void addLocationListener(final LocationMonitorListener callBack) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                LocationMonitor.this.callBacks.add(callBack);
            }
        });
    }

    public void removeLocationListener(final LocationMonitorListener callBack) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                LocationMonitor.this.callBacks.remove(callBack);
            }
        });
    }

    public Location getLastLocation() {
        return this.lastLocation;
    }

    public boolean isMockLocationEnabled() {
        boolean isMockLocation = false;
        try {
            int uuid;
            AppOpsManager opsManager;
            isMockLocation = Build.VERSION.SDK_INT >= 23 ? (opsManager = (AppOpsManager)this.context.getSystemService("appops")).checkOp("android:mock_location", uuid = Process.myUid(), this.context.getPackageName()) == 0 : !Settings.Secure.getString((ContentResolver)this.context.getContentResolver(), (String)"mock_location").equals("0");
        }
        catch (Exception e) {
            return isMockLocation;
        }
        return isMockLocation;
    }

    public void setCurrentLocation(final Location location) {
        if (this.isMockLocationEnabled()) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    if (!LocationMonitor.this.proxSeePermissionManager.isPermissionGranted(LocationMonitor.this.context)) {
                        return;
                    }
                    if (!LocationMonitor.this.googleApiClient.isConnected()) {
                        return;
                    }
                    if (location == null) {
                        LocationMonitor.this.api.setMockMode(LocationMonitor.this.googleApiClient, false);
                        LocationMonitor.this.lastLocation = null;
                    } else {
                        location.setProvider(LocationMonitor.MOCK_LOCATION_PROVIDER);
                        LocationMonitor.this.api.setMockMode(LocationMonitor.this.googleApiClient, true);
                        LocationMonitor.this.api.setMockLocation(LocationMonitor.this.googleApiClient, location);
                        LocationMonitor.this.onLocationChanged(location);
                    }
                }
            });
        }
    }

    public void onConnected(Bundle bundle) {
        if (!this.proxSeePermissionManager.isPermissionGranted(this.context)) {
            return;
        }
        LocationRequest request = new LocationRequest();
        request.setInterval(300000L);
        request.setFastestInterval(120000L);
        request.setPriority(102);
        if (this.isMockLocationEnabled()) {
            this.api.setMockMode(this.googleApiClient, false);
        }
        this.api.requestLocationUpdates(this.googleApiClient, request, (LocationListener)this);
        this.api.flushLocations(this.googleApiClient);
    }

    public void onConnectionSuspended(int i) {
    }

    public void onConnectionFailed(ConnectionResult connectionResult) {
    }

    public void onLocationChanged(final Location location) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                Log.d((String)TAG, (String)("Location Updated " + location));
                LocationMonitor.this.flushLocation(location);
            }
        });
    }

    private void flushLocation(Location location) {
        if (this.isAccurateLocation(location)) {
            this.lastLocation = location;
            Log.d((String)TAG, (String)("Location flushed " + location));
            HashSet<LocationMonitorListener> locationCallBacks = new HashSet<LocationMonitorListener>(this.callBacks);
            for (LocationMonitorListener callBack : locationCallBacks) {
                callBack.didUpdateLocation(location);
            }
        }
    }

    private boolean isAccurateLocation(Location location) {
        if (location == null) {
            return false;
        }
        if (location.getProvider().equals(MOCK_LOCATION_PROVIDER) || Build.VERSION.SDK_INT >= 18 && location.isFromMockProvider()) {
            return true;
        }
        long now = System.currentTimeMillis();
        if (now - location.getTime() > 20000L) {
            return false;
        }
        int newAccuracy = (int)location.getAccuracy();
        if (newAccuracy < 0) {
            return false;
        }
        return (long)newAccuracy <= 105L;
    }
}

