/*
 * Decompiled with CFR 0.152.
 */
package io.proxsee.sdk.service;

import android.util.Log;
import io.proxsee.sdk.beaconsnearby.BeaconNearbyMonitor;
import io.proxsee.sdk.beaconsnearby.BeaconNearbyNotifier;
import io.proxsee.sdk.listener.BluetoothStateListener;
import io.proxsee.sdk.listener.SDKEventListener;
import io.proxsee.sdk.misc.Utils;
import io.proxsee.sdk.service.ProxSeeService;
import javax.inject.Inject;
import org.altbeacon.beacon.BeaconConsumer;
import org.altbeacon.beacon.BeaconManager;
import org.altbeacon.beacon.RangeNotifier;

public class ProxSeeRealBeaconService
implements ProxSeeService,
BluetoothStateListener,
SDKEventListener {
    private static final String TAG = ProxSeeRealBeaconService.class.getSimpleName();
    private boolean started;
    private boolean sdkEnabled;
    @Inject
    BeaconManager beaconManager;
    @Inject
    BeaconConsumer beaconConsumer;
    @Inject
    BeaconNearbyNotifier beaconNearbyNotifier;
    @Inject
    BeaconNearbyMonitor monitor;

    @Override
    public void start() {
        if (!this.isRunning()) {
            if (Utils.isBluetoothAdapterOn()) {
                this.beaconManager.addRangeNotifier((RangeNotifier)this.monitor);
                this.monitor.setBeaconNearbyNotifier(this.beaconNearbyNotifier);
                this.beaconManager.bind(this.beaconConsumer);
                this.started = true;
                Log.d((String)TAG, (String)"ProxSeeRealBeaconService has started...");
            } else {
                Log.w((String)TAG, (String)"ProxSeeRealBeaconService failed to start with bluetooth currently turned off...the service will automatically start once bluetooth is turned on.");
            }
        }
    }

    @Override
    public void stop() {
        if (this.isRunning()) {
            this.beaconManager.unbind(this.beaconConsumer);
            this.monitor.setBeaconNearbyNotifier(null);
            this.beaconManager.removeRangeNotifier((RangeNotifier)this.monitor);
            this.started = false;
            Log.d((String)TAG, (String)"ProxSeeRealBeaconService has been stopped!");
        }
    }

    @Override
    public void onBluetoothTurnedOff() {
        if (!this.sdkEnabled) {
            return;
        }
        this.stop();
    }

    @Override
    public void onBluetoothTurnedOn() {
        if (!this.sdkEnabled) {
            return;
        }
        this.start();
    }

    @Override
    public boolean isRunning() {
        return this.started;
    }

    @Override
    public void onSDKStarting() {
        this.sdkEnabled = true;
    }

    @Override
    public void onSDKStopping() {
        this.sdkEnabled = false;
    }

    @Override
    public void onSDKReset() {
    }
}

