/*
 * Decompiled with CFR 0.152.
 */
package io.proxsee.sdk;

import android.content.Context;
import android.content.SharedPreferences;
import android.location.Location;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import android.util.Log;
import io.proxsee.sdk.ProxSeeBeaconHandler;
import io.proxsee.sdk.ProxSeeContext;
import io.proxsee.sdk.beaconsnearby.BeaconNearbyNotifier;
import io.proxsee.sdk.beaconsnearby.NearbyBeacon;
import io.proxsee.sdk.client.request.BeaconsAroundMeHeadRequest;
import io.proxsee.sdk.client.request.BeaconsAroundMeRequest;
import io.proxsee.sdk.client.request.ProxSeeRequest;
import io.proxsee.sdk.client.response.BeaconsAroundMeResponse;
import io.proxsee.sdk.client.response.Response;
import io.proxsee.sdk.entity.ProxSeeBeacon;
import io.proxsee.sdk.entity.ProxSeeBeaconRepository;
import io.proxsee.sdk.listener.ConnectionStateListener;
import io.proxsee.sdk.model.ProxseeBeaconsNearByResult;
import io.proxsee.sdk.virtual.LocationMonitorListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

public class ProxSeeBeaconMonitor
implements BeaconNearbyNotifier,
ConnectionStateListener,
LocationMonitorListener {
    private static final String TAG = ProxSeeBeaconMonitor.class.getSimpleName();
    private static final String PROXSEE_BEACONS_LAST_TIME_SEEN = "PROXSEE_BEACONS_LAST_TIME_SEEN";
    private static final String PROXSEE_BEACONS_ACTIVE_ETAG = "PROXSEE_BEACONS_ACTIVE_ETAG";
    @Inject
    ProxSeeBeaconRepository proxSeeBeaconRepository;
    @Inject
    ProxSeeBeaconHandler beaconHandler;
    @Inject
    ProxSeeContext proxSeeContext;
    private boolean isExecutingActiveBeacons;
    private Handler activeBeaconsHandler;
    private Handler proxseeHandler;
    private Location lastLocationExecuted;
    private long lastTimeSeen;
    private String etag;

    public ProxSeeBeaconMonitor(ProxSeeContext proxSeeContext, Handler proxseeHandler) {
        this.proxseeHandler = proxseeHandler;
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)proxSeeContext.getApplicationContext());
        this.lastTimeSeen = prefs.getLong(PROXSEE_BEACONS_LAST_TIME_SEEN, 0L);
        this.etag = prefs.getString(PROXSEE_BEACONS_ACTIVE_ETAG, "");
        this.activeBeaconsHandler = ProxSeeBeaconMonitor.createActiveBeaconsHandler();
    }

    @Override
    public void onDataConnectionAvailable() {
        Log.d((String)TAG, (String)"data connection available");
    }

    @Override
    public void onDataConnectionLost() {
        Log.d((String)TAG, (String)"data connection unavailable!");
    }

    @Override
    public void didUpdateLocation(Location location) {
        this.lastLocationExecuted = location;
        Log.d((String)TAG, (String)("did change location " + location));
        this.updateActiveBeacons();
        this.innerLocationUpdate(location);
    }

    private void innerLocationUpdate(Location location) {
        List<ProxSeeBeacon> previousAllBeaconsInRange = this.proxSeeBeaconRepository.findAll(true);
        List<ProxSeeBeacon> previousRealBeaconsInRange = this.proxSeeBeaconRepository.findAll(true, false);
        Collection<ProxSeeBeacon> currentBeaconsInRange = this.findProxSeeBeaconsInRange(location);
        currentBeaconsInRange.addAll(previousRealBeaconsInRange);
        this.processBeaconsEvent(previousAllBeaconsInRange, currentBeaconsInRange);
    }

    @Override
    public void didChangeBeaconsNearby(Collection<NearbyBeacon> currentNearbyBeacons, Collection<NearbyBeacon> noLongerVisibleBeacons) {
        Log.d((String)TAG, (String)("didChangeBeaconsNearby " + TextUtils.join((CharSequence)"\n", currentNearbyBeacons)));
        this.updateActiveBeacons();
        Collection<ProxSeeBeacon> convertedBeacons = this.convertToProxSeeBeacons((Collection<NearbyBeacon>)(currentNearbyBeacons.isEmpty() ? Collections.EMPTY_LIST : currentNearbyBeacons));
        List<ProxSeeBeacon> previousAllBeaconsInRange = this.proxSeeBeaconRepository.findAll(true);
        this.innerDidChangeBeaconsNearby(convertedBeacons, noLongerVisibleBeacons, previousAllBeaconsInRange);
    }

    private void innerDidChangeBeaconsNearby(Collection<ProxSeeBeacon> convertedBeacons, Collection<NearbyBeacon> noLongerVisibleBeacons, Collection<ProxSeeBeacon> previousAllBeaconsInRange) {
        List<ProxSeeBeacon> previousVirtualBeaconsInRange = this.proxSeeBeaconRepository.findAll(true, true);
        Collection<ProxSeeBeacon> currentBeaconsInRange = this.populateProxSeeBeaconsInRange(convertedBeacons);
        currentBeaconsInRange.addAll(previousVirtualBeaconsInRange);
        this.populateLastExitTime(previousAllBeaconsInRange, noLongerVisibleBeacons);
        this.processBeaconsEvent(previousAllBeaconsInRange, currentBeaconsInRange);
    }

    private void populateLastExitTime(Collection<ProxSeeBeacon> proxSeeBeacons, Collection<NearbyBeacon> noLongerVisibleBeacons) {
        Collection<ProxSeeBeacon> convertedBeacons = this.convertToProxSeeBeacons((Collection<NearbyBeacon>)(noLongerVisibleBeacons.isEmpty() ? Collections.EMPTY_LIST : noLongerVisibleBeacons));
        Log.d((String)TAG, (String)("Before populating\n" + TextUtils.join((CharSequence)"\n", proxSeeBeacons)));
        block0: for (ProxSeeBeacon previousBeacon : convertedBeacons) {
            for (ProxSeeBeacon proxSeeBeacon : proxSeeBeacons) {
                if (!proxSeeBeacon.equals(previousBeacon)) continue;
                proxSeeBeacon.setExitAt(previousBeacon.getExitAt());
                continue block0;
            }
        }
        Log.d((String)TAG, (String)("After populating\n" + TextUtils.join((CharSequence)"\n", proxSeeBeacons)));
    }

    private void processBeaconsEvent(Collection<ProxSeeBeacon> previousBeaconsInRange, Collection<ProxSeeBeacon> currentBeaconsInRange) {
        ProxseeBeaconsNearByResult result = new ProxseeBeaconsNearByResult(currentBeaconsInRange, previousBeaconsInRange);
        Collection<ProxSeeBeacon> checkInBeacons = result.getAddedBeacons();
        Collection<ProxSeeBeacon> checkOutBeacons = result.getRemovedBeacons();
        this.updateProxseeBeacon(checkOutBeacons, false);
        this.proxSeeBeaconRepository.addOrUpdate(checkOutBeacons);
        this.updateProxseeBeacon(currentBeaconsInRange, true);
        this.proxSeeBeaconRepository.addOrUpdate(currentBeaconsInRange);
        if (!result.hasBeaconsChanged() && !result.hasTagsChanged()) {
            Log.d((String)TAG, (String)String.format("BEACON STATE NOT CHANGED", new Object[0]));
            return;
        }
        this.beaconHandler.checkOut(checkOutBeacons);
        this.beaconHandler.checkIn(checkInBeacons);
        this.beaconHandler.processTagChanges(result);
    }

    private Collection<ProxSeeBeacon> findProxSeeBeaconsInRange(Location location) {
        List<ProxSeeBeacon> locationBeacons = this.proxSeeBeaconRepository.findAllWithVirtualFlag(true);
        ArrayList<ProxSeeBeacon> proxSeeBeacons = new ArrayList<ProxSeeBeacon>();
        for (ProxSeeBeacon beacon : locationBeacons) {
            if (!beacon.isGeofence() || !beacon.containsLocation(location)) continue;
            proxSeeBeacons.add(beacon);
        }
        return proxSeeBeacons;
    }

    private Collection<ProxSeeBeacon> convertToProxSeeBeacons(Collection<NearbyBeacon> altBeacons) {
        ArrayList<ProxSeeBeacon> proxSeeBeacons = new ArrayList<ProxSeeBeacon>();
        for (NearbyBeacon beacon : altBeacons) {
            ProxSeeBeacon proxSeeBeacon = new ProxSeeBeacon(beacon);
            proxSeeBeacons.add(proxSeeBeacon);
        }
        return proxSeeBeacons;
    }

    private void updateProxseeBeacon(Collection<ProxSeeBeacon> proxSeeBeacons, boolean nearBy) {
        for (ProxSeeBeacon beacon : proxSeeBeacons) {
            beacon.setNearby(nearBy);
        }
    }

    private Collection<ProxSeeBeacon> populateProxSeeBeaconsInRange(Collection<ProxSeeBeacon> beaconsAround) {
        List<ProxSeeBeacon> allBeacons = this.proxSeeBeaconRepository.findAllWithVirtualFlag(false);
        ArrayList<ProxSeeBeacon> proxSeeBeacons = new ArrayList<ProxSeeBeacon>();
        for (ProxSeeBeacon beacon : beaconsAround) {
            ProxSeeBeacon proxSeeBeacon = beacon.findMatch(allBeacons);
            if (proxSeeBeacon == null) {
                proxSeeBeacon = new ProxSeeBeacon(beacon);
            }
            proxSeeBeacon.setRssi(beacon.getRssi());
            proxSeeBeacons.add(proxSeeBeacon);
        }
        return proxSeeBeacons;
    }

    private boolean hasChanged() {
        Log.d((String)TAG, (String)"Head Check :");
        ProxSeeRequest.RequestResult result = new BeaconsAroundMeHeadRequest(this.proxSeeContext, this.etag).invokeSync();
        Response response = (Response)result.getResponse();
        if (result.isHasError()) {
            Log.d((String)TAG, (String)"error HeadCheck");
            return false;
        }
        boolean hasChanged = response.getStatus() == 200;
        Log.d((String)TAG, (String)("Has Changed :" + hasChanged));
        return hasChanged;
    }

    private void updateActiveBeacons() {
        if (this.isExecutingActiveBeacons) {
            Log.d((String)TAG, (String)"is Executing active beacon request return");
            return;
        }
        this.isExecutingActiveBeacons = true;
        this.activeBeaconsHandler.post(new Runnable(){

            @Override
            public void run() {
                Log.d((String)TAG, (String)"Executing head active beacon request");
                boolean hasChanged = ProxSeeBeaconMonitor.this.hasChanged();
                if (!hasChanged) {
                    ProxSeeBeaconMonitor.this.proxseeHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            ProxSeeBeaconMonitor.this.isExecutingActiveBeacons = false;
                            Log.d((String)TAG, (String)"active beacons has not changed , reset flag");
                        }
                    });
                    return;
                }
                Log.d((String)TAG, (String)"Executing get active beacon request");
                ProxSeeRequest.RequestResult result = new BeaconsAroundMeRequest(ProxSeeBeaconMonitor.this.proxSeeContext).invokeSync();
                Log.d((String)TAG, (String)"Fetching beacons:");
                BeaconsAroundMeResponse response = (BeaconsAroundMeResponse)result.getResponse();
                if (result.isHasError()) {
                    ProxSeeBeaconMonitor.this.proxseeHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            ProxSeeBeaconMonitor.this.isExecutingActiveBeacons = false;
                            Log.d((String)TAG, (String)"error fetching beacons, reset flag");
                        }
                    });
                    return;
                }
                String _etag = "";
                try {
                    _etag = response.getNetworkResponse().header("ETag");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                final String finaleTag = _etag;
                final ArrayList<Object> fetched = new ArrayList<Object>(Arrays.asList((Object[])response.getBody()));
                ProxSeeBeaconMonitor.this.proxseeHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        Log.d((String)TAG, (String)"finish get active beacon request and reset flag");
                        ProxSeeBeaconMonitor.this.isExecutingActiveBeacons = false;
                        if (!ProxSeeBeaconMonitor.this.proxSeeContext.isSDKStarted()) {
                            Log.d((String)TAG, (String)"Dump reflushing sdk stopped");
                            return;
                        }
                        List<ProxSeeBeacon> previousAllBeaconsInRange = ProxSeeBeaconMonitor.this.proxSeeBeaconRepository.findAll(true);
                        block0: for (ProxSeeBeacon prevBeacon : previousAllBeaconsInRange) {
                            for (ProxSeeBeacon newBeacon : fetched) {
                                if (!prevBeacon.equals(newBeacon)) continue;
                                newBeacon.setNearby(true);
                                continue block0;
                            }
                        }
                        ProxSeeBeaconMonitor.this.proxSeeBeaconRepository.deleteAll();
                        ProxSeeBeaconMonitor.this.proxSeeBeaconRepository.addOrUpdate(fetched);
                        long now = System.currentTimeMillis();
                        ProxSeeBeaconMonitor.this.updateLastTimeSeenAndEtag(now, finaleTag);
                        List<ProxSeeBeacon> detectedRealBeacons = ProxSeeBeaconMonitor.this.proxSeeBeaconRepository.findAll(true, false);
                        Log.d((String)TAG, (String)("Reflushing beacons after active beacons updated: " + TextUtils.join((CharSequence)"\n", detectedRealBeacons)));
                        ProxSeeBeaconMonitor.this.innerDidChangeBeaconsNearby(detectedRealBeacons, new ArrayList(), previousAllBeaconsInRange);
                        if (ProxSeeBeaconMonitor.this.lastLocationExecuted != null && now - ProxSeeBeaconMonitor.this.lastLocationExecuted.getTime() < 180000L) {
                            Log.d((String)TAG, (String)("Reflushing location after active beacons updated: " + ProxSeeBeaconMonitor.this.lastLocationExecuted));
                            ProxSeeBeaconMonitor.this.innerLocationUpdate(ProxSeeBeaconMonitor.this.lastLocationExecuted);
                        }
                    }
                });
            }
        });
    }

    public void updateLastTimeSeenAndEtag(long lastTimeSeen, String etag) {
        this.lastTimeSeen = lastTimeSeen;
        this.etag = etag;
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)this.proxSeeContext.getApplicationContext());
        SharedPreferences.Editor editor = prefs.edit();
        editor.putLong(PROXSEE_BEACONS_LAST_TIME_SEEN, this.lastTimeSeen);
        editor.putString(PROXSEE_BEACONS_ACTIVE_ETAG, etag);
        editor.commit();
    }

    public long getLastTimeSeen() {
        return this.lastTimeSeen;
    }

    public void reset() {
        this.lastLocationExecuted = null;
        this.isExecutingActiveBeacons = false;
        this.proxSeeBeaconRepository.deleteAll();
        this.updateLastTimeSeenAndEtag(0L, "");
    }

    private static Handler createActiveBeaconsHandler() {
        HandlerThread thread = new HandlerThread("io.proxsee.sdk.active.beacons.handler");
        thread.start();
        Looper looper = thread.getLooper();
        return new Handler(looper);
    }
}

