/*
 * Decompiled with CFR 0.152.
 */
package io.proxsee.sdk;

import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.util.Log;
import io.proxsee.sdk.ProxSeeContext;
import io.proxsee.sdk.client.request.HandshakeRequest;
import io.proxsee.sdk.client.request.ProxSeeRequest;
import io.proxsee.sdk.client.response.HandshakeResponse;
import io.proxsee.sdk.entity.Handshake;
import io.proxsee.sdk.entity.HandshakeRepository;
import io.proxsee.sdk.entity.ProxSeeBeacon;
import io.proxsee.sdk.listener.ConnectionStateListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;

public class ProxSeeOfflineHandler
implements ConnectionStateListener {
    private static final String TAG = ProxSeeOfflineHandler.class.getSimpleName();
    @Inject
    HandshakeRepository repository;
    @Inject
    ProxSeeContext proxSeeContext;
    private Handler handler = ProxSeeOfflineHandler.createProxSeeHandler();

    public void checkIn(Collection<ProxSeeBeacon> beacons) {
        Date at = new Date();
        ArrayList<Handshake> handshakes = new ArrayList<Handshake>();
        for (ProxSeeBeacon beacon : beacons) {
            Log.d((String)TAG, (String)("Will checkin beacon " + beacon));
            Handshake handshake = new Handshake(beacon.getMajor(), beacon.getMinor(), beacon.getRssi(), at.getTime(), null, false);
            handshakes.add(handshake);
        }
        this.submitHandshakes(handshakes);
    }

    private static Handler createProxSeeHandler() {
        HandlerThread thread = new HandlerThread("io.proxsee.sdk.thread.offline");
        thread.start();
        Looper looper = thread.getLooper();
        return new Handler(looper);
    }

    public void checkOut(Collection<ProxSeeBeacon> beacons) {
        long now = new Date().getTime();
        ArrayList<Handshake> handshakes = new ArrayList<Handshake>();
        for (ProxSeeBeacon beacon : beacons) {
            long time = now;
            if (beacon.getExitAt() != 0L) {
                time = beacon.getExitAt();
            }
            Log.d((String)TAG, (String)("Will checkout beacon " + beacon));
            Handshake handshake = new Handshake(beacon.getMajor(), beacon.getMinor(), 0, null, time, false);
            handshakes.add(handshake);
        }
        this.submitHandshakes(handshakes);
    }

    private void submitHandshakes(final List<Handshake> handshakes) {
        Log.d((String)TAG, (String)"Will try to submit handshakes...");
        this.executeSynchronously(new Runnable(){

            @Override
            public void run() {
                ProxSeeOfflineHandler.this.repository.addOrUpdate(handshakes);
                List<Handshake> data = ProxSeeOfflineHandler.this.repository.findAll();
                ProxSeeOfflineHandler.this.repository.deleteAll();
                int max = data.size();
                int threshold = max - ProxSeeOfflineHandler.this.proxSeeContext.getMaxOfflineHandshake();
                for (int i = 0; i < threshold; ++i) {
                    data.remove(0);
                }
                ProxSeeOfflineHandler.this.repository.addOrUpdate(data);
                boolean isConnected = ProxSeeOfflineHandler.this.isConnected();
                if (isConnected) {
                    Log.d((String)TAG, (String)"Flushing offline handshakes...");
                    ProxSeeOfflineHandler.this.flushOfflineHandshakes();
                } else {
                    Log.d((String)TAG, (String)"Device is not connected...will try later");
                }
            }
        });
    }

    private void executeSynchronously(final Runnable aRunnable) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                aRunnable.run();
            }
        });
    }

    private void flushOfflineHandshakes() {
        List<Handshake> handshakes = this.repository.findAll();
        if (handshakes.isEmpty()) {
            return;
        }
        this.repository.deleteAll();
        List<Handshake> mergedHandshakes = this.repository.mergeHandshakes(handshakes);
        ProxSeeRequest.RequestResult result = new HandshakeRequest(this.proxSeeContext, mergedHandshakes).invokeSync();
        HandshakeResponse response = (HandshakeResponse)result.getResponse();
        if (result.isHasError()) {
            Log.w((String)TAG, (String)"Failed to flush offline handshakes!");
            if (response.getStatus() >= 500) {
                this.repository.addOrUpdate(handshakes);
                Log.w((String)TAG, (String)"Re-adding handshakes!");
            }
        } else {
            Log.d((String)TAG, (String)"Offline handshakes flushed successfully!");
        }
    }

    private boolean isConnected() {
        ConnectivityManager cm = (ConnectivityManager)this.proxSeeContext.getApplicationContext().getSystemService("connectivity");
        NetworkInfo info = cm.getActiveNetworkInfo();
        return info != null && info.isConnected();
    }

    @Override
    public void onDataConnectionAvailable() {
        this.executeSynchronously(new Runnable(){

            @Override
            public void run() {
                ProxSeeOfflineHandler.this.flushOfflineHandshakes();
            }
        });
    }

    @Override
    public void onDataConnectionLost() {
    }
}

