/*
 * Decompiled with CFR 0.152.
 */
package io.proxsee.sdk.beaconsnearby;

import io.proxsee.sdk.entity.ProxSeeBeacon;
import java.util.UUID;
import org.altbeacon.beacon.Beacon;

public class NearbyBeacon {
    private UUID uuid;
    private Integer major;
    private Integer minor;
    private int rssi;
    private long lastTimeNotSeen;

    public NearbyBeacon(Beacon beacon) {
        this.uuid = beacon.getId1().toUuid();
        this.major = beacon.getId2().toInt();
        this.minor = beacon.getId3().toInt();
        this.rssi = beacon.getRssi();
    }

    public NearbyBeacon(ProxSeeBeacon beacon, UUID uuid) {
        this.uuid = uuid;
        this.major = beacon.getMajor();
        this.minor = beacon.getMinor();
        this.rssi = beacon.getRssi();
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public Integer getMajor() {
        return this.major;
    }

    public Integer getMinor() {
        return this.minor;
    }

    public int getRssi() {
        return this.rssi;
    }

    public long getLastTimeNotSeen() {
        return this.lastTimeNotSeen;
    }

    void setLastTimeNotSeen(long lastTimeNotSeen) {
        this.lastTimeNotSeen = lastTimeNotSeen;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NearbyBeacon that = (NearbyBeacon)o;
        if (!this.uuid.equals(that.uuid)) {
            return false;
        }
        if (!this.major.equals(that.major)) {
            return false;
        }
        return this.minor.equals(that.minor);
    }

    public int hashCode() {
        int result = this.uuid.hashCode();
        result = 31 * result + this.major.hashCode();
        result = 31 * result + this.minor.hashCode();
        return result;
    }

    public String toString() {
        return "NearbyBeacon{uuid=" + this.uuid + ", major=" + this.major + ", minor=" + this.minor + ", rssi=" + this.rssi + ", lastTimeNotSeen=" + this.lastTimeNotSeen + ", Since:" + (this.lastTimeNotSeen == 0L ? "-" : Double.valueOf((double)(System.currentTimeMillis() - this.lastTimeNotSeen) / 1000.0)) + '}';
    }
}

