/*
 * Decompiled with CFR 0.152.
 */
package io.proxsee.sdk.broadcastreceiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import io.proxsee.sdk.listener.BluetoothStateListener;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;

public class BluetoothBroadcastReceiver {
    private Integer lastState;
    private final Set<BluetoothStateListener> listeners = Collections.newSetFromMap(new WeakHashMap());

    public BluetoothBroadcastReceiver(Context context, Handler handler) {
        BroadcastReceiver reciever = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if (BluetoothBroadcastReceiver.this.listeners.isEmpty()) {
                    return;
                }
                String action = intent.getAction();
                if (action.equals("android.bluetooth.adapter.action.STATE_CHANGED")) {
                    int currentState = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", Integer.MIN_VALUE);
                    if (BluetoothBroadcastReceiver.this.lastState == null || BluetoothBroadcastReceiver.this.lastState != currentState) {
                        BluetoothBroadcastReceiver.this.lastState = currentState;
                        switch (currentState) {
                            case 10: {
                                for (BluetoothStateListener listener : BluetoothBroadcastReceiver.this.listeners) {
                                    listener.onBluetoothTurnedOff();
                                }
                                break;
                            }
                            case 13: {
                                break;
                            }
                            case 12: {
                                for (BluetoothStateListener listener : BluetoothBroadcastReceiver.this.listeners) {
                                    listener.onBluetoothTurnedOn();
                                }
                                break;
                            }
                        }
                    }
                }
            }
        };
        context.registerReceiver(reciever, new IntentFilter("android.bluetooth.adapter.action.STATE_CHANGED"), null, handler);
    }

    public void addListener(BluetoothStateListener listener) {
        this.listeners.add(listener);
    }
}

