/*
 * Decompiled with CFR 0.152.
 */
package io.proxsee.sdk.broadcastreceiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import io.proxsee.sdk.listener.ConnectionStateListener;
import io.proxsee.sdk.misc.Utils;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;

public class ConnectionBroadcastReceiver {
    private State lastState;
    private final Set<ConnectionStateListener> listeners = Collections.newSetFromMap(new WeakHashMap());

    public ConnectionBroadcastReceiver(Context context, Handler handler) {
        this.lastState = this.getConnectionState(context);
        BroadcastReceiver receiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if (ConnectionBroadcastReceiver.this.listeners.isEmpty()) {
                    return;
                }
                State currentState = ConnectionBroadcastReceiver.this.getConnectionState(context);
                if (ConnectionBroadcastReceiver.this.lastState != currentState) {
                    ConnectionBroadcastReceiver.this.lastState = currentState;
                    switch (currentState) {
                        case CONNECTED: {
                            for (ConnectionStateListener listener : ConnectionBroadcastReceiver.this.listeners) {
                                listener.onDataConnectionAvailable();
                            }
                            break;
                        }
                        case DISCONNECTED: {
                            for (ConnectionStateListener listener : ConnectionBroadcastReceiver.this.listeners) {
                                listener.onDataConnectionLost();
                            }
                            break;
                        }
                    }
                }
            }
        };
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        context.registerReceiver(receiver, filter, null, handler);
    }

    public void addListener(ConnectionStateListener listener) {
        this.listeners.add(listener);
    }

    private State getConnectionState(Context context) {
        return Utils.isNetworkAvailable(context) ? State.CONNECTED : State.DISCONNECTED;
    }

    private static enum State {
        CONNECTED,
        DISCONNECTED;

    }
}

