/*
 * Decompiled with CFR 0.152.
 */
package io.proxsee.sdk.client.request;

import io.proxsee.sdk.ProxSeeContext;
import io.proxsee.sdk.client.Callback;
import io.proxsee.sdk.client.request.AbstractProxSeeRequest;
import io.proxsee.sdk.client.request.Client;
import io.proxsee.sdk.client.response.BeaconsAroundMeResponse;
import io.proxsee.sdk.entity.ProxSeeBeacon;
import io.proxsee.sdk.misc.Utils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;
import okhttp3.Request;
import okhttp3.Response;

public class BeaconsAroundMeRequest
extends AbstractProxSeeRequest<BeaconsAroundMeResponse> {
    private final String PATH = "/api/beacons/active";
    private final ProxSeeContext proxSeeContext;

    public BeaconsAroundMeRequest(ProxSeeContext context) {
        this.proxSeeContext = context;
    }

    @Override
    public void invoke(final Callback<BeaconsAroundMeResponse> callback) {
        String url = this.proxSeeContext.getApiURL() + String.format("/api/beacons/active", new Object[0]);
        Request.Builder builder = new Request.Builder().url(url);
        HashMap<String, String> headers = this.proxSeeContext.getHeaders();
        for (Map.Entry pair : headers.entrySet()) {
            builder.addHeader((String)pair.getKey(), (String)pair.getValue());
        }
        builder.addHeader("Cache-Control", "no-cache");
        Request request = builder.build();
        okhttp3.Callback requestCallBack = new okhttp3.Callback(){

            public void onFailure(Call call, IOException e) {
                call.cancel();
                callback.onError(new BeaconsAroundMeResponse(600), e);
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (response.isSuccessful()) {
                    Response response1 = response.networkResponse();
                    if (response1 == null) {
                        response1 = response.cacheResponse();
                    }
                    ProxSeeBeacon[] proxSeeBeacons = (ProxSeeBeacon[])Utils.getGson().fromJson(response.body().string(), ProxSeeBeacon[].class);
                    callback.onSuccess(new BeaconsAroundMeResponse(response.code(), response1, proxSeeBeacons));
                } else {
                    callback.onError(new BeaconsAroundMeResponse(response.code()), null);
                }
            }
        };
        Client.getInstance(this.proxSeeContext.getApplicationContext()).execute(request, requestCallBack);
    }
}

