/*
 * Decompiled with CFR 0.152.
 */
package io.proxsee.sdk.client.request;

import android.content.Context;
import io.proxsee.sdk.client.interceptors.UserAgentInterceptor;
import io.proxsee.sdk.misc.Utils;
import java.util.concurrent.TimeUnit;
import okhttp3.Cache;
import okhttp3.Callback;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;

final class Client {
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    public static final int APPLICATION_ERROR_CODE = 600;
    private static Client instance;
    private static int CACHE_SIZE_BYTES;
    private static final int DEFAULT_TIMEOUT_MS = 30000;
    private OkHttpClient client;

    private Client(Context context) {
        Cache cache = new Cache(context.getCacheDir(), (long)CACHE_SIZE_BYTES);
        UserAgentInterceptor interceptor = new UserAgentInterceptor(Utils.getDeviceModelInformation());
        this.client = new OkHttpClient.Builder().connectTimeout(30000L, TimeUnit.MILLISECONDS).cache(cache).addInterceptor((Interceptor)interceptor).build();
    }

    static synchronized Client getInstance(Context context) {
        if (instance == null) {
            instance = new Client(context);
        }
        return instance;
    }

    void execute(Request request, Callback callback) {
        this.client.newCall(request).enqueue(callback);
    }

    static {
        CACHE_SIZE_BYTES = 0xA00000;
    }
}

