/*
 * Decompiled with CFR 0.152.
 */
package io.proxsee.sdk.client.request;

import io.proxsee.sdk.ProxSeeContext;
import io.proxsee.sdk.client.Callback;
import io.proxsee.sdk.client.request.AbstractProxSeeRequest;
import io.proxsee.sdk.client.request.Client;
import io.proxsee.sdk.client.response.HandshakeResponse;
import io.proxsee.sdk.entity.Handshake;
import io.proxsee.sdk.misc.Utils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class HandshakeRequest
extends AbstractProxSeeRequest<HandshakeResponse> {
    private final String PATH = "/api/device/%s/handshakes";
    private static final String TAG = HandshakeRequest.class.getSimpleName();
    private final String deviceUUID;
    private final List<Handshake> handshakes;
    private final ProxSeeContext proxSeeContext;

    public HandshakeRequest(ProxSeeContext context, List<Handshake> handshakes) {
        this.proxSeeContext = context;
        this.deviceUUID = context.getDeviceId();
        this.handshakes = handshakes;
    }

    @Override
    public void invoke(final Callback<HandshakeResponse> callback) {
        String url = this.proxSeeContext.getApiURL() + String.format("/api/device/%s/handshakes", this.deviceUUID);
        String json = Utils.getGson().toJson(this.handshakes);
        RequestBody body = RequestBody.create((MediaType)Client.JSON, (String)json);
        Request.Builder builder = new Request.Builder().url(url).post(body);
        HashMap<String, String> headers = this.proxSeeContext.getHeaders();
        for (Map.Entry pair : headers.entrySet()) {
            builder.addHeader((String)pair.getKey(), (String)pair.getValue());
        }
        Request request = builder.build();
        okhttp3.Callback requestCallBack = new okhttp3.Callback(){

            public void onFailure(Call call, IOException e) {
                call.cancel();
                callback.onError(new HandshakeResponse(600), e);
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (response.isSuccessful()) {
                    callback.onSuccess(new HandshakeResponse(response.code()));
                } else {
                    callback.onError(new HandshakeResponse(response.code()), null);
                }
            }
        };
        Client.getInstance(this.proxSeeContext.getApplicationContext()).execute(request, requestCallBack);
    }
}

