/*
 * Decompiled with CFR 0.152.
 */
package io.proxsee.sdk.client.request;

import io.proxsee.sdk.ProxSeeContext;
import io.proxsee.sdk.client.Callback;
import io.proxsee.sdk.client.request.AbstractProxSeeRequest;
import io.proxsee.sdk.client.request.Client;
import io.proxsee.sdk.client.response.MonitoringRegionsResponse;
import io.proxsee.sdk.entity.MonitoringRegion;
import io.proxsee.sdk.misc.Utils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;
import okhttp3.Request;
import okhttp3.Response;

public class MonitoringRegionsRequest
extends AbstractProxSeeRequest<MonitoringRegionsResponse> {
    private final String PATH = "/api/monitoringregions";
    private final ProxSeeContext proxSeeContext;

    public MonitoringRegionsRequest(ProxSeeContext context) {
        this.proxSeeContext = context;
    }

    @Override
    public void invoke(final Callback<MonitoringRegionsResponse> callback) {
        String url = this.proxSeeContext.getApiURL() + "/api/monitoringregions";
        Request.Builder builder = new Request.Builder().url(url);
        HashMap<String, String> headers = this.proxSeeContext.getHeaders();
        for (Map.Entry pair : headers.entrySet()) {
            builder.addHeader((String)pair.getKey(), (String)pair.getValue());
        }
        Request request = builder.build();
        okhttp3.Callback requestCallBack = new okhttp3.Callback(){

            public void onFailure(Call call, IOException e) {
                call.cancel();
                callback.onError(new MonitoringRegionsResponse(600), e);
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (response.isSuccessful()) {
                    MonitoringRegion[] regions = (MonitoringRegion[])Utils.getGson().fromJson(response.body().string(), MonitoringRegion[].class);
                    callback.onSuccess(new MonitoringRegionsResponse(response.code(), regions));
                } else {
                    callback.onError(new MonitoringRegionsResponse(response.code()), null);
                }
            }
        };
        Client.getInstance(this.proxSeeContext.getApplicationContext()).execute(request, requestCallBack);
    }
}

