/*
 * Decompiled with CFR 0.152.
 */
package io.proxsee.sdk.client.request;

import android.util.Log;
import io.proxsee.sdk.ProxSeeContext;
import io.proxsee.sdk.client.Callback;
import io.proxsee.sdk.client.request.AbstractProxSeeRequest;
import io.proxsee.sdk.client.request.Client;
import io.proxsee.sdk.client.response.UpdateMetadataResponse;
import io.proxsee.sdk.misc.Utils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class UpdateMetadataRequest
extends AbstractProxSeeRequest<UpdateMetadataResponse> {
    private static String TAG = UpdateMetadataRequest.class.getSimpleName();
    private final String PATH = "/api/device/%s/metadata";
    private final String deviceUUID;
    private final ProxSeeContext proxSeeContext;
    private final Map<String, Object> data;

    public UpdateMetadataRequest(ProxSeeContext context, Map<String, Object> data) {
        this.proxSeeContext = context;
        this.deviceUUID = context.getDeviceId();
        this.data = data;
    }

    @Override
    public void invoke(final Callback<UpdateMetadataResponse> callback) {
        String json = null;
        try {
            HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>();
            map.put("metadata", this.data);
            json = Utils.getGson().toJson(map);
        }
        catch (Exception ex) {
            Log.d((String)TAG, (String)"Failed to parse metadata");
            callback.onError(null, ex);
            return;
        }
        String url = this.proxSeeContext.getApiURL() + String.format("/api/device/%s/metadata", this.deviceUUID);
        RequestBody body = RequestBody.create((MediaType)Client.JSON, (String)json);
        Request.Builder builder = new Request.Builder().url(url).put(body);
        HashMap<String, String> headers = this.proxSeeContext.getHeaders();
        for (Map.Entry pair : headers.entrySet()) {
            builder.addHeader((String)pair.getKey(), (String)pair.getValue());
        }
        Request request = builder.build();
        okhttp3.Callback requestCallBack = new okhttp3.Callback(){

            public void onFailure(Call call, IOException e) {
                call.cancel();
                callback.onError(new UpdateMetadataResponse(600), e);
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (response.isSuccessful()) {
                    callback.onSuccess(new UpdateMetadataResponse(response.code()));
                } else {
                    callback.onError(new UpdateMetadataResponse(response.code()), null);
                }
            }
        };
        Client.getInstance(this.proxSeeContext.getApplicationContext()).execute(request, requestCallBack);
    }
}

