/*
 * Decompiled with CFR 0.152.
 */
package io.proxsee.sdk.dagger;

import android.content.Context;
import android.os.Handler;
import dagger.Module;
import dagger.Provides;
import io.proxsee.sdk.DeviceStateMonitor;
import io.proxsee.sdk.ProxSeeBeaconConsumer;
import io.proxsee.sdk.ProxSeeBeaconHandler;
import io.proxsee.sdk.ProxSeeBeaconMonitor;
import io.proxsee.sdk.ProxSeeContext;
import io.proxsee.sdk.ProxSeeOfflineHandler;
import io.proxsee.sdk.ProxSeePermissionManager;
import io.proxsee.sdk.beaconsnearby.BeaconNearbyMonitor;
import io.proxsee.sdk.beaconsnearby.BeaconNearbyNotifier;
import io.proxsee.sdk.beaconsnearby.HasSubscribedRegion;
import io.proxsee.sdk.broadcast.ProxSeeBroadcaster;
import io.proxsee.sdk.broadcastreceiver.BluetoothBroadcastReceiver;
import io.proxsee.sdk.broadcastreceiver.ConnectionBroadcastReceiver;
import io.proxsee.sdk.broadcastreceiver.LocationBroadcastReceiver;
import io.proxsee.sdk.broadcastreceiver.PermissionsBroadcastReciever;
import io.proxsee.sdk.broadcastreceiver.SDKStateBroadcastReceiver;
import io.proxsee.sdk.cache.InternalCache;
import io.proxsee.sdk.dagger.ProxSeeSDKComponent;
import io.proxsee.sdk.entity.HandshakeRepository;
import io.proxsee.sdk.entity.MonitoringRegionRepository;
import io.proxsee.sdk.entity.ProxSeeBeaconRepository;
import io.proxsee.sdk.entity.Session;
import io.proxsee.sdk.listener.BluetoothStateListener;
import io.proxsee.sdk.listener.ConnectionStateListener;
import io.proxsee.sdk.listener.LocationStateListener;
import io.proxsee.sdk.listener.PermissionsStateListener;
import io.proxsee.sdk.listener.SDKEventListener;
import io.proxsee.sdk.permissions.PermissionsMonitor;
import io.proxsee.sdk.service.ProxSeeRealBeaconService;
import io.proxsee.sdk.service.ProxSeeService;
import io.proxsee.sdk.service.ProxSeeVirtualBeaconService;
import io.proxsee.sdk.virtual.LocationMonitor;
import io.proxsee.sdk.virtual.LocationMonitorListener;
import javax.inject.Named;
import javax.inject.Singleton;
import org.altbeacon.beacon.BeaconConsumer;
import org.altbeacon.beacon.BeaconManager;
import org.altbeacon.beacon.BeaconParser;

@Module
public class ProxSeeSDKModule {
    private final ProxSeeContext proxSeeContext;
    private final ConnectionBroadcastReceiver connectionBroadcastReceiver;
    private final BluetoothBroadcastReceiver bluetoothBroadcastReceiver;
    private final SDKStateBroadcastReceiver sdkStateBroadcastReceiver;
    private final LocationBroadcastReceiver locationBroadcastReceiver;
    private final PermissionsBroadcastReciever permissionsBroadcastReciever;
    private final Handler proxseeSDKHandler;
    private ProxSeeSDKComponent proxSeeSDKComponent;

    public ProxSeeSDKModule(ProxSeeContext context, Handler handler) {
        this.proxSeeContext = context;
        this.proxseeSDKHandler = handler;
        this.sdkStateBroadcastReceiver = new SDKStateBroadcastReceiver(context.getApplicationContext(), handler);
        this.connectionBroadcastReceiver = new ConnectionBroadcastReceiver(context.getApplicationContext(), handler);
        this.bluetoothBroadcastReceiver = new BluetoothBroadcastReceiver(context.getApplicationContext(), handler);
        this.locationBroadcastReceiver = new LocationBroadcastReceiver(context.getApplicationContext(), handler);
        this.permissionsBroadcastReciever = new PermissionsBroadcastReciever(context.getApplicationContext(), handler);
    }

    public <T> T decorate(T obj) {
        if (obj instanceof BluetoothStateListener) {
            this.bluetoothBroadcastReceiver.addListener((BluetoothStateListener)obj);
        }
        if (obj instanceof ConnectionStateListener) {
            this.connectionBroadcastReceiver.addListener((ConnectionStateListener)obj);
        }
        if (obj instanceof SDKEventListener) {
            this.sdkStateBroadcastReceiver.addListener((SDKEventListener)obj);
        }
        if (obj instanceof LocationStateListener) {
            this.locationBroadcastReceiver.addListener((LocationStateListener)obj);
        }
        if (obj instanceof PermissionsStateListener) {
            this.permissionsBroadcastReciever.addListener((PermissionsStateListener)obj);
        }
        return obj;
    }

    @Provides
    @Singleton
    ProxSeeContext provideProxSeeContext() {
        return this.proxSeeContext;
    }

    @Provides
    @Singleton
    Context provideContext() {
        return this.proxSeeContext.getApplicationContext();
    }

    @Provides
    @Singleton
    ProxSeeBroadcaster providerProxSeeBroadcaster(Context context) {
        return new ProxSeeBroadcaster(context);
    }

    @Provides
    @Singleton
    BeaconManager providerBeaconManager(Context context) {
        BeaconManager beaconManager = BeaconManager.getInstanceForApplication((Context)context);
        beaconManager.setForegroundScanPeriod(this.proxSeeContext.getBluetoothScanPeriod());
        beaconManager.setForegroundBetweenScanPeriod(this.proxSeeContext.getBluetoothScanBetweenPeriod());
        beaconManager.setBackgroundScanPeriod(this.proxSeeContext.getBluetoothScanPeriod());
        beaconManager.setBackgroundBetweenScanPeriod(this.proxSeeContext.getBluetoothScanBetweenPeriod());
        beaconManager.getBeaconParsers().add(new BeaconParser().setBeaconLayout(this.proxSeeContext.getBeaconLayout()));
        return beaconManager;
    }

    @Provides
    @Singleton
    Session providerSession(Context context) {
        return Session.getInstance(context);
    }

    @Provides
    @Singleton
    MonitoringRegionRepository providerMonitoringRegionRepository() {
        MonitoringRegionRepository instance = new MonitoringRegionRepository();
        this.proxSeeSDKComponent.inject(instance);
        return this.decorate(instance);
    }

    @Provides
    @Singleton
    BeaconNearbyMonitor providerBeaconNearbyMonitor() {
        BeaconNearbyMonitor instance = new BeaconNearbyMonitor();
        this.proxSeeSDKComponent.inject(instance);
        return this.decorate(instance);
    }

    @Provides
    @Singleton
    HandshakeRepository providerHandshakeRepository() {
        HandshakeRepository instance = new HandshakeRepository();
        this.proxSeeSDKComponent.inject(instance);
        return this.decorate(instance);
    }

    @Provides
    @Singleton
    ProxSeeOfflineHandler providerProxSeeOfflineHandler() {
        ProxSeeOfflineHandler instance = new ProxSeeOfflineHandler();
        this.proxSeeSDKComponent.inject(instance);
        return this.decorate(instance);
    }

    @Provides
    @Singleton
    ProxSeeBeaconRepository providerProxSeeBeaconRepository() {
        ProxSeeBeaconRepository instance = new ProxSeeBeaconRepository();
        this.proxSeeSDKComponent.inject(instance);
        return this.decorate(instance);
    }

    @Provides
    @Singleton
    ProxSeeBeaconHandler providerProxSeeBeaconHandler() {
        ProxSeeBeaconHandler instance = new ProxSeeBeaconHandler();
        this.proxSeeSDKComponent.inject(instance);
        return this.decorate(instance);
    }

    @Provides
    @Singleton
    HasSubscribedRegion providesHasSubscribedRegion(BeaconNearbyMonitor nearbyMonitor) {
        return nearbyMonitor;
    }

    @Provides
    @Singleton
    ProxSeeBeaconConsumer providerProxSeeBeaconConsumer() {
        ProxSeeBeaconConsumer instance = new ProxSeeBeaconConsumer();
        this.proxSeeSDKComponent.inject(instance);
        return this.decorate(instance);
    }

    @Provides
    @Singleton
    BeaconNearbyNotifier providerBeaconNearbyNotifier(ProxSeeBeaconMonitor monitor) {
        return monitor;
    }

    @Provides
    @Singleton
    BeaconConsumer providerBeaconConsumer(ProxSeeBeaconConsumer consumer) {
        return consumer;
    }

    @Provides
    @Singleton
    ProxSeeBeaconMonitor providerProxSeeBeaconMonitor() {
        ProxSeeBeaconMonitor instance = new ProxSeeBeaconMonitor(this.proxSeeContext, this.proxseeSDKHandler);
        this.proxSeeSDKComponent.inject(instance);
        return this.decorate(instance);
    }

    @Provides
    @Singleton
    LocationMonitorListener providerLationMonitorListener(ProxSeeBeaconMonitor monitor) {
        return monitor;
    }

    @Provides
    @Singleton
    @Named(value="Real")
    ProxSeeService providerProxSeeRealBeaconService() {
        ProxSeeRealBeaconService instance = new ProxSeeRealBeaconService();
        this.proxSeeSDKComponent.inject(instance);
        return this.decorate(instance);
    }

    @Provides
    @Singleton
    @Named(value="Virtual")
    ProxSeeService providerProxSeeVirtualBeaconService() {
        ProxSeeVirtualBeaconService instance = new ProxSeeVirtualBeaconService();
        this.proxSeeSDKComponent.inject(instance);
        return this.decorate(instance);
    }

    @Provides
    @Singleton
    InternalCache providerInternalCache() {
        InternalCache instance = new InternalCache();
        this.proxSeeSDKComponent.inject(instance);
        return this.decorate(instance);
    }

    @Provides
    @Singleton
    DeviceStateMonitor providerDeviceStateMonitor() {
        DeviceStateMonitor instance = new DeviceStateMonitor();
        this.proxSeeSDKComponent.inject(instance);
        return this.decorate(instance);
    }

    @Provides
    @Singleton
    Handler providerProxSeeSDKHandler() {
        return this.proxseeSDKHandler;
    }

    @Provides
    @Singleton
    ProxSeePermissionManager providerProxSeePermissionManager() {
        return new ProxSeePermissionManager();
    }

    @Provides
    @Singleton
    PermissionsMonitor providesPermissionsBroadcaster(Context context, ProxSeePermissionManager permissionManager, Handler handler) {
        return new PermissionsMonitor(context, permissionManager, handler);
    }

    @Provides
    @Singleton
    LocationMonitor providesLocation(ProxSeePermissionManager permissionManager, Context context) {
        return this.decorate(new LocationMonitor(permissionManager, context, this.proxseeSDKHandler));
    }

    public void setProxSeeSDKComponent(ProxSeeSDKComponent proxSeeSDKComponent) {
        this.proxSeeSDKComponent = proxSeeSDKComponent;
    }
}

