/*
 * Decompiled with CFR 0.152.
 */
package io.proxsee.sdk.entity;

import android.util.Log;
import io.proxsee.sdk.entity.Persistable;
import io.proxsee.sdk.entity.RawObject;
import io.proxsee.sdk.entity.Session;
import io.realm.Realm;
import io.realm.RealmObject;
import io.realm.RealmResults;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;

public class BaseRepository<K extends RealmObject, T extends Persistable<K>> {
    private static final String TAG = BaseRepository.class.getSimpleName();
    @Inject
    Session session;

    public List<T> findAll() {
        RealmResults entities = this.getRealm().allObjects(this.getEntityClass());
        ArrayList rawObjects = new ArrayList(entities.size());
        for (RealmObject entity : entities) {
            rawObjects.add(((RawObject)entity).getRawObject());
        }
        return rawObjects;
    }

    public void deleteAll() {
        this.executeTransaction(new RealmTransaction(){

            @Override
            public void execute(Realm realm) {
                realm.where(BaseRepository.this.getEntityClass()).findAll().clear();
            }
        });
    }

    public void addOrUpdate(T entity) {
        this.executeTransaction(new RealmTransaction((Persistable)entity){
            final /* synthetic */ Persistable val$entity;
            {
                this.val$entity = persistable;
            }

            @Override
            public void execute(Realm realm) {
                realm.copyToRealmOrUpdate(this.val$entity.getEntity());
            }
        });
    }

    public void addOrUpdate(final Collection<T> entities) {
        if (entities != null && !entities.isEmpty()) {
            this.executeTransaction(new RealmTransaction(){

                @Override
                public void execute(Realm realm) {
                    for (Persistable entity : entities) {
                        realm.copyToRealmOrUpdate(entity.getEntity());
                    }
                }
            });
        }
    }

    protected Class<K> getEntityClass() {
        ParameterizedType superclass = (ParameterizedType)this.getClass().getGenericSuperclass();
        return (Class)superclass.getActualTypeArguments()[0];
    }

    protected Realm getRealm() {
        return this.session.getOrCreate();
    }

    protected void executeTransaction(RealmTransaction transaction) {
        Realm realm = this.getRealm();
        realm.beginTransaction();
        try {
            transaction.execute(realm);
            realm.commitTransaction();
        }
        catch (RuntimeException e) {
            realm.cancelTransaction();
            Log.d((String)TAG, (String)("Error during transaction. " + e));
        }
        catch (Error e) {
            Log.d((String)TAG, (String)("Error during transaction. " + e));
            throw e;
        }
    }

    protected static interface RealmTransaction {
        public void execute(Realm var1);
    }
}

