/*
 * Decompiled with CFR 0.152.
 */
package io.proxsee.sdk.entity;

import io.proxsee.sdk.entity.HandshakeRealm;
import io.proxsee.sdk.entity.Persistable;
import java.util.UUID;

public class Handshake
implements Persistable<HandshakeRealm> {
    private int major;
    private int minor;
    private Long checkinAt;
    private Long checkoutAt;
    private int rssi;
    private boolean impliedCheckout;
    private transient long id;
    private transient long createdAt;

    public long getCreatedAt() {
        return this.createdAt;
    }

    public Handshake(long id, long createdAt, int beaconMajor, int beaconMinor, int rssi, Long checkinAt, Long checkoutAt, boolean isImplicit) {
        this.id = id;
        this.createdAt = createdAt;
        this.major = beaconMajor;
        this.minor = beaconMinor;
        this.checkinAt = checkinAt;
        this.checkoutAt = checkoutAt;
        this.impliedCheckout = isImplicit;
        this.rssi = rssi;
    }

    public Handshake(int beaconMajor, int beaconMinor, int rssi, Long checkinAt, Long checkoutAt, boolean isImplicit) {
        this(UUID.randomUUID().getMostSignificantBits(), System.currentTimeMillis(), beaconMajor, beaconMinor, rssi, checkinAt, checkoutAt, isImplicit);
    }

    public Handshake(Handshake checkInHandshake, Handshake checkoutHandshake) {
        this(checkInHandshake.getId(), checkInHandshake.getCreatedAt(), checkInHandshake.getMajor(), checkInHandshake.getMinor(), checkInHandshake.getRssi(), checkInHandshake.getCheckinAt(), checkoutHandshake.getCheckoutAt(), checkoutHandshake.isImpliedCheckout());
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public Long getCheckinAt() {
        return this.checkinAt;
    }

    public Long getCheckoutAt() {
        return this.checkoutAt;
    }

    public boolean isImpliedCheckout() {
        return this.impliedCheckout;
    }

    public long getId() {
        return this.id;
    }

    public int getRssi() {
        return this.rssi;
    }

    public void setRssi(int rssi) {
        this.rssi = rssi;
    }

    @Override
    public HandshakeRealm getEntity() {
        HandshakeRealm handshakeRealm = new HandshakeRealm();
        handshakeRealm.setId(this.getId());
        handshakeRealm.setCreatedAt(this.getCreatedAt());
        handshakeRealm.setMajor(this.getMajor());
        handshakeRealm.setMinor(this.getMinor());
        handshakeRealm.setCheckinAt(this.getCheckinAt() == null ? 0L : this.getCheckinAt());
        handshakeRealm.setCheckoutAt(this.getCheckoutAt() == null ? 0L : this.getCheckoutAt());
        handshakeRealm.setImpliedCheckout(this.isImpliedCheckout());
        handshakeRealm.setRssi(this.getRssi());
        return handshakeRealm;
    }
}

