/*
 * Decompiled with CFR 0.152.
 */
package io.proxsee.sdk.entity;

import io.proxsee.sdk.entity.BaseRepository;
import io.proxsee.sdk.entity.Handshake;
import io.proxsee.sdk.entity.HandshakeRealm;
import io.realm.RealmResults;
import java.util.ArrayList;
import java.util.List;

public class HandshakeRepository
extends BaseRepository<HandshakeRealm, Handshake> {
    @Override
    public List<Handshake> findAll() {
        RealmResults entities = this.getRealm().where(HandshakeRealm.class).findAllSorted("createdAt");
        ArrayList<Handshake> rawObjects = new ArrayList<Handshake>(entities.size());
        for (HandshakeRealm entity : entities) {
            rawObjects.add(entity.getRawObject());
        }
        return rawObjects;
    }

    public List<Handshake> mergeHandshakes(List<Handshake> handshakes) {
        ArrayList<Handshake> mergedHandshakes = new ArrayList<Handshake>();
        ArrayList<Handshake> mutableHandshakes = new ArrayList<Handshake>(handshakes);
        while (mutableHandshakes.size() > 0) {
            Handshake checkoutHandShake;
            Handshake handshake = (Handshake)mutableHandshakes.get(0);
            mutableHandshakes.remove(0);
            if (handshake.getCheckoutAt() == null && (checkoutHandShake = this.lookForNextCheckoutHandShakeOf(handshake, mutableHandshakes)) != null) {
                mutableHandshakes.remove(checkoutHandShake);
                handshake = new Handshake(handshake, checkoutHandShake);
            }
            mergedHandshakes.add(handshake);
        }
        return mergedHandshakes;
    }

    private Handshake lookForNextCheckoutHandShakeOf(Handshake checkInHandshake, List<Handshake> handshakes) {
        for (Handshake nextHandShake : handshakes) {
            if (nextHandShake.getCheckinAt() != null && nextHandShake.getMajor() == checkInHandshake.getMajor() && nextHandShake.getMinor() == checkInHandshake.getMinor() && nextHandShake.getCheckinAt() > checkInHandshake.getCheckinAt()) break;
            if (nextHandShake.getCheckinAt() != null || nextHandShake.getMajor() != checkInHandshake.getMajor() || nextHandShake.getMinor() != checkInHandshake.getMinor() || nextHandShake.getCheckoutAt() <= checkInHandshake.getCheckinAt()) continue;
            return nextHandShake;
        }
        return null;
    }
}

