/*
 * Decompiled with CFR 0.152.
 */
package io.proxsee.sdk.entity;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Handler;
import android.preference.PreferenceManager;
import android.util.Log;
import io.realm.Realm;
import io.realm.RealmConfiguration;
import java.util.concurrent.ConcurrentHashMap;

public class Session {
    private static final String TAG = Session.class.getSimpleName();
    private static final String REALM_FILE = "proxsee.realm";
    private static final String REALM_FILE_VERSION = "proxsee.REALM_FILE_VERSION";
    private static final int REALM_CURRENT_VERSION = 1;
    private static Session instance;
    private final RealmConfiguration realmConfiguration;
    private ThreadLocal<Realm> realmThreadLocal = new ThreadLocal();
    private ConcurrentHashMap<Long, Realm> openRealms = new ConcurrentHashMap();

    private Session(Context context) {
        this.realmConfiguration = new RealmConfiguration.Builder(context).deleteRealmIfMigrationNeeded().name(REALM_FILE).build();
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)context);
        int version = prefs.getInt(REALM_FILE_VERSION, 0);
        if (version < 1) {
            Realm.deleteRealm((RealmConfiguration)this.realmConfiguration);
        }
        SharedPreferences.Editor editor = prefs.edit();
        editor.putInt(REALM_FILE_VERSION, 1);
        editor.commit();
    }

    public static synchronized Session getInstance(Context context) {
        if (instance == null) {
            instance = new Session(context);
        }
        return instance;
    }

    public Realm getOrCreate() {
        Realm realm = this.realmThreadLocal.get();
        if (realm == null) {
            final Realm finalRealm = realm = Realm.getInstance((RealmConfiguration)this.realmConfiguration);
            new Handler().post(new Runnable(){

                @Override
                public void run() {
                    Session.this.close(finalRealm);
                }
            });
            this.realmThreadLocal.set(realm);
            this.openRealms.put(Thread.currentThread().getId(), realm);
            Log.d((String)TAG, (String)("Opening sessions. Opened sessions count:" + this.openRealms.size()));
        }
        return realm;
    }

    private void close(Realm realm) {
        this.realmThreadLocal.set(null);
        if (realm != null && !realm.isClosed()) {
            realm.close();
        }
        this.openRealms.remove(Thread.currentThread().getId());
        Log.d((String)TAG, (String)("Closing session. Opened sessions count:" + this.openRealms.size()));
    }
}

