/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import android.util.JsonReader;
import android.util.JsonToken;
import io.proxsee.sdk.entity.HandshakeRealm;
import io.realm.Realm;
import io.realm.RealmFieldType;
import io.realm.RealmObject;
import io.realm.exceptions.RealmMigrationNeededException;
import io.realm.internal.ColumnInfo;
import io.realm.internal.ImplicitTransaction;
import io.realm.internal.RealmObjectProxy;
import io.realm.internal.Table;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class HandshakeRealmRealmProxy
extends HandshakeRealm
implements RealmObjectProxy {
    private final HandshakeRealmColumnInfo columnInfo;
    private static final List<String> FIELD_NAMES;

    HandshakeRealmRealmProxy(ColumnInfo columnInfo) {
        this.columnInfo = (HandshakeRealmColumnInfo)columnInfo;
    }

    @Override
    public int getMajor() {
        this.realm.checkIfValid();
        return (int)this.row.getLong(this.columnInfo.majorIndex);
    }

    @Override
    public void setMajor(int value) {
        this.realm.checkIfValid();
        this.row.setLong(this.columnInfo.majorIndex, (long)value);
    }

    @Override
    public int getMinor() {
        this.realm.checkIfValid();
        return (int)this.row.getLong(this.columnInfo.minorIndex);
    }

    @Override
    public void setMinor(int value) {
        this.realm.checkIfValid();
        this.row.setLong(this.columnInfo.minorIndex, (long)value);
    }

    @Override
    public int getRssi() {
        this.realm.checkIfValid();
        return (int)this.row.getLong(this.columnInfo.rssiIndex);
    }

    @Override
    public void setRssi(int value) {
        this.realm.checkIfValid();
        this.row.setLong(this.columnInfo.rssiIndex, (long)value);
    }

    @Override
    public long getCheckinAt() {
        this.realm.checkIfValid();
        return this.row.getLong(this.columnInfo.checkinAtIndex);
    }

    @Override
    public void setCheckinAt(long value) {
        this.realm.checkIfValid();
        this.row.setLong(this.columnInfo.checkinAtIndex, value);
    }

    @Override
    public long getCheckoutAt() {
        this.realm.checkIfValid();
        return this.row.getLong(this.columnInfo.checkoutAtIndex);
    }

    @Override
    public void setCheckoutAt(long value) {
        this.realm.checkIfValid();
        this.row.setLong(this.columnInfo.checkoutAtIndex, value);
    }

    @Override
    public boolean isImpliedCheckout() {
        this.realm.checkIfValid();
        return this.row.getBoolean(this.columnInfo.impliedCheckoutIndex);
    }

    @Override
    public void setImpliedCheckout(boolean value) {
        this.realm.checkIfValid();
        this.row.setBoolean(this.columnInfo.impliedCheckoutIndex, value);
    }

    @Override
    public long getCreatedAt() {
        this.realm.checkIfValid();
        return this.row.getLong(this.columnInfo.createdAtIndex);
    }

    @Override
    public void setCreatedAt(long value) {
        this.realm.checkIfValid();
        this.row.setLong(this.columnInfo.createdAtIndex, value);
    }

    @Override
    public long getId() {
        this.realm.checkIfValid();
        return this.row.getLong(this.columnInfo.idIndex);
    }

    @Override
    public void setId(long value) {
        this.realm.checkIfValid();
        this.row.setLong(this.columnInfo.idIndex, value);
    }

    public static Table initTable(ImplicitTransaction transaction) {
        if (!transaction.hasTable("class_HandshakeRealm")) {
            Table table = transaction.getTable("class_HandshakeRealm");
            table.addColumn(RealmFieldType.INTEGER, "major", false);
            table.addColumn(RealmFieldType.INTEGER, "minor", false);
            table.addColumn(RealmFieldType.INTEGER, "rssi", false);
            table.addColumn(RealmFieldType.INTEGER, "checkinAt", false);
            table.addColumn(RealmFieldType.INTEGER, "checkoutAt", false);
            table.addColumn(RealmFieldType.BOOLEAN, "impliedCheckout", false);
            table.addColumn(RealmFieldType.INTEGER, "createdAt", false);
            table.addColumn(RealmFieldType.INTEGER, "id", false);
            table.addSearchIndex(table.getColumnIndex("id"));
            table.setPrimaryKey("id");
            return table;
        }
        return transaction.getTable("class_HandshakeRealm");
    }

    public static HandshakeRealmColumnInfo validateTable(ImplicitTransaction transaction) {
        if (transaction.hasTable("class_HandshakeRealm")) {
            Table table = transaction.getTable("class_HandshakeRealm");
            if (table.getColumnCount() != 8L) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Field count does not match - expected 8 but was " + table.getColumnCount());
            }
            HashMap<String, RealmFieldType> columnTypes = new HashMap<String, RealmFieldType>();
            for (long i = 0L; i < 8L; ++i) {
                columnTypes.put(table.getColumnName(i), table.getColumnType(i));
            }
            HandshakeRealmColumnInfo columnInfo = new HandshakeRealmColumnInfo(transaction.getPath(), table);
            if (!columnTypes.containsKey("major")) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Missing field 'major' in existing Realm file. Either remove field or migrate using io.realm.internal.Table.addColumn().");
            }
            if (columnTypes.get("major") != RealmFieldType.INTEGER) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Invalid type 'int' for field 'major' in existing Realm file.");
            }
            if (table.isColumnNullable(columnInfo.majorIndex)) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Field 'major' does support null values in the existing Realm file. Use corresponding boxed type for field 'major' or migrate using io.realm.internal.Table.convertColumnToNotNullable().");
            }
            if (!columnTypes.containsKey("minor")) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Missing field 'minor' in existing Realm file. Either remove field or migrate using io.realm.internal.Table.addColumn().");
            }
            if (columnTypes.get("minor") != RealmFieldType.INTEGER) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Invalid type 'int' for field 'minor' in existing Realm file.");
            }
            if (table.isColumnNullable(columnInfo.minorIndex)) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Field 'minor' does support null values in the existing Realm file. Use corresponding boxed type for field 'minor' or migrate using io.realm.internal.Table.convertColumnToNotNullable().");
            }
            if (!columnTypes.containsKey("rssi")) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Missing field 'rssi' in existing Realm file. Either remove field or migrate using io.realm.internal.Table.addColumn().");
            }
            if (columnTypes.get("rssi") != RealmFieldType.INTEGER) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Invalid type 'int' for field 'rssi' in existing Realm file.");
            }
            if (table.isColumnNullable(columnInfo.rssiIndex)) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Field 'rssi' does support null values in the existing Realm file. Use corresponding boxed type for field 'rssi' or migrate using io.realm.internal.Table.convertColumnToNotNullable().");
            }
            if (!columnTypes.containsKey("checkinAt")) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Missing field 'checkinAt' in existing Realm file. Either remove field or migrate using io.realm.internal.Table.addColumn().");
            }
            if (columnTypes.get("checkinAt") != RealmFieldType.INTEGER) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Invalid type 'long' for field 'checkinAt' in existing Realm file.");
            }
            if (table.isColumnNullable(columnInfo.checkinAtIndex)) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Field 'checkinAt' does support null values in the existing Realm file. Use corresponding boxed type for field 'checkinAt' or migrate using io.realm.internal.Table.convertColumnToNotNullable().");
            }
            if (!columnTypes.containsKey("checkoutAt")) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Missing field 'checkoutAt' in existing Realm file. Either remove field or migrate using io.realm.internal.Table.addColumn().");
            }
            if (columnTypes.get("checkoutAt") != RealmFieldType.INTEGER) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Invalid type 'long' for field 'checkoutAt' in existing Realm file.");
            }
            if (table.isColumnNullable(columnInfo.checkoutAtIndex)) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Field 'checkoutAt' does support null values in the existing Realm file. Use corresponding boxed type for field 'checkoutAt' or migrate using io.realm.internal.Table.convertColumnToNotNullable().");
            }
            if (!columnTypes.containsKey("impliedCheckout")) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Missing field 'impliedCheckout' in existing Realm file. Either remove field or migrate using io.realm.internal.Table.addColumn().");
            }
            if (columnTypes.get("impliedCheckout") != RealmFieldType.BOOLEAN) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Invalid type 'boolean' for field 'impliedCheckout' in existing Realm file.");
            }
            if (table.isColumnNullable(columnInfo.impliedCheckoutIndex)) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Field 'impliedCheckout' does support null values in the existing Realm file. Use corresponding boxed type for field 'impliedCheckout' or migrate using io.realm.internal.Table.convertColumnToNotNullable().");
            }
            if (!columnTypes.containsKey("createdAt")) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Missing field 'createdAt' in existing Realm file. Either remove field or migrate using io.realm.internal.Table.addColumn().");
            }
            if (columnTypes.get("createdAt") != RealmFieldType.INTEGER) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Invalid type 'long' for field 'createdAt' in existing Realm file.");
            }
            if (table.isColumnNullable(columnInfo.createdAtIndex)) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Field 'createdAt' does support null values in the existing Realm file. Use corresponding boxed type for field 'createdAt' or migrate using io.realm.internal.Table.convertColumnToNotNullable().");
            }
            if (!columnTypes.containsKey("id")) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Missing field 'id' in existing Realm file. Either remove field or migrate using io.realm.internal.Table.addColumn().");
            }
            if (columnTypes.get("id") != RealmFieldType.INTEGER) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Invalid type 'long' for field 'id' in existing Realm file.");
            }
            if (table.isColumnNullable(columnInfo.idIndex)) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Field 'id' does support null values in the existing Realm file. Use corresponding boxed type for field 'id' or migrate using io.realm.internal.Table.convertColumnToNotNullable().");
            }
            if (table.getPrimaryKey() != table.getColumnIndex("id")) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Primary key not defined for field 'id' in existing Realm file. Add @PrimaryKey.");
            }
            if (!table.hasSearchIndex(table.getColumnIndex("id"))) {
                throw new RealmMigrationNeededException(transaction.getPath(), "Index not defined for field 'id' in existing Realm file. Either set @Index or migrate using io.realm.internal.Table.removeSearchIndex().");
            }
            return columnInfo;
        }
        throw new RealmMigrationNeededException(transaction.getPath(), "The HandshakeRealm class is missing from the schema for this Realm.");
    }

    public static String getTableName() {
        return "class_HandshakeRealm";
    }

    public static List<String> getFieldNames() {
        return FIELD_NAMES;
    }

    public static HandshakeRealm createOrUpdateUsingJsonObject(Realm realm, JSONObject json, boolean update) throws JSONException {
        HandshakeRealm obj = null;
        if (update) {
            long rowIndex;
            Table table = realm.getTable(HandshakeRealm.class);
            long pkColumnIndex = table.getPrimaryKey();
            if (!json.isNull("id") && (rowIndex = table.findFirstLong(pkColumnIndex, json.getLong("id"))) != -1L) {
                obj = new HandshakeRealmRealmProxy(realm.schema.getColumnInfo(HandshakeRealm.class));
                obj.realm = realm;
                obj.row = table.getUncheckedRow(rowIndex);
            }
        }
        if (obj == null) {
            obj = json.has("id") ? (json.isNull("id") ? (HandshakeRealm)realm.createObject(HandshakeRealm.class, null) : (HandshakeRealm)realm.createObject(HandshakeRealm.class, (Object)json.getLong("id"))) : (HandshakeRealm)realm.createObject(HandshakeRealm.class);
        }
        if (json.has("major")) {
            if (json.isNull("major")) {
                throw new IllegalArgumentException("Trying to set non-nullable field major to null.");
            }
            obj.setMajor(json.getInt("major"));
        }
        if (json.has("minor")) {
            if (json.isNull("minor")) {
                throw new IllegalArgumentException("Trying to set non-nullable field minor to null.");
            }
            obj.setMinor(json.getInt("minor"));
        }
        if (json.has("rssi")) {
            if (json.isNull("rssi")) {
                throw new IllegalArgumentException("Trying to set non-nullable field rssi to null.");
            }
            obj.setRssi(json.getInt("rssi"));
        }
        if (json.has("checkinAt")) {
            if (json.isNull("checkinAt")) {
                throw new IllegalArgumentException("Trying to set non-nullable field checkinAt to null.");
            }
            obj.setCheckinAt(json.getLong("checkinAt"));
        }
        if (json.has("checkoutAt")) {
            if (json.isNull("checkoutAt")) {
                throw new IllegalArgumentException("Trying to set non-nullable field checkoutAt to null.");
            }
            obj.setCheckoutAt(json.getLong("checkoutAt"));
        }
        if (json.has("impliedCheckout")) {
            if (json.isNull("impliedCheckout")) {
                throw new IllegalArgumentException("Trying to set non-nullable field impliedCheckout to null.");
            }
            obj.setImpliedCheckout(json.getBoolean("impliedCheckout"));
        }
        if (json.has("createdAt")) {
            if (json.isNull("createdAt")) {
                throw new IllegalArgumentException("Trying to set non-nullable field createdAt to null.");
            }
            obj.setCreatedAt(json.getLong("createdAt"));
        }
        if (json.has("id")) {
            if (json.isNull("id")) {
                throw new IllegalArgumentException("Trying to set non-nullable field id to null.");
            }
            obj.setId(json.getLong("id"));
        }
        return obj;
    }

    public static HandshakeRealm createUsingJsonStream(Realm realm, JsonReader reader) throws IOException {
        HandshakeRealm obj = (HandshakeRealm)realm.createObject(HandshakeRealm.class);
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("major")) {
                if (reader.peek() == JsonToken.NULL) {
                    reader.skipValue();
                    throw new IllegalArgumentException("Trying to set non-nullable field major to null.");
                }
                obj.setMajor(reader.nextInt());
                continue;
            }
            if (name.equals("minor")) {
                if (reader.peek() == JsonToken.NULL) {
                    reader.skipValue();
                    throw new IllegalArgumentException("Trying to set non-nullable field minor to null.");
                }
                obj.setMinor(reader.nextInt());
                continue;
            }
            if (name.equals("rssi")) {
                if (reader.peek() == JsonToken.NULL) {
                    reader.skipValue();
                    throw new IllegalArgumentException("Trying to set non-nullable field rssi to null.");
                }
                obj.setRssi(reader.nextInt());
                continue;
            }
            if (name.equals("checkinAt")) {
                if (reader.peek() == JsonToken.NULL) {
                    reader.skipValue();
                    throw new IllegalArgumentException("Trying to set non-nullable field checkinAt to null.");
                }
                obj.setCheckinAt(reader.nextLong());
                continue;
            }
            if (name.equals("checkoutAt")) {
                if (reader.peek() == JsonToken.NULL) {
                    reader.skipValue();
                    throw new IllegalArgumentException("Trying to set non-nullable field checkoutAt to null.");
                }
                obj.setCheckoutAt(reader.nextLong());
                continue;
            }
            if (name.equals("impliedCheckout")) {
                if (reader.peek() == JsonToken.NULL) {
                    reader.skipValue();
                    throw new IllegalArgumentException("Trying to set non-nullable field impliedCheckout to null.");
                }
                obj.setImpliedCheckout(reader.nextBoolean());
                continue;
            }
            if (name.equals("createdAt")) {
                if (reader.peek() == JsonToken.NULL) {
                    reader.skipValue();
                    throw new IllegalArgumentException("Trying to set non-nullable field createdAt to null.");
                }
                obj.setCreatedAt(reader.nextLong());
                continue;
            }
            if (name.equals("id")) {
                if (reader.peek() == JsonToken.NULL) {
                    reader.skipValue();
                    throw new IllegalArgumentException("Trying to set non-nullable field id to null.");
                }
                obj.setId(reader.nextLong());
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return obj;
    }

    public static HandshakeRealm copyOrUpdate(Realm realm, HandshakeRealm object, boolean update, Map<RealmObject, RealmObjectProxy> cache) {
        if (object.realm != null && object.realm.getPath().equals(realm.getPath())) {
            return object;
        }
        HandshakeRealmRealmProxy realmObject = null;
        boolean canUpdate = update;
        if (canUpdate) {
            long pkColumnIndex;
            Table table = realm.getTable(HandshakeRealm.class);
            long rowIndex = table.findFirstLong(pkColumnIndex = table.getPrimaryKey(), object.getId());
            if (rowIndex != -1L) {
                realmObject = new HandshakeRealmRealmProxy(realm.schema.getColumnInfo(HandshakeRealm.class));
                realmObject.realm = realm;
                realmObject.row = table.getUncheckedRow(rowIndex);
                cache.put(object, realmObject);
            } else {
                canUpdate = false;
            }
        }
        if (canUpdate) {
            return HandshakeRealmRealmProxy.update(realm, realmObject, object, cache);
        }
        return HandshakeRealmRealmProxy.copy(realm, object, update, cache);
    }

    public static HandshakeRealm copy(Realm realm, HandshakeRealm newObject, boolean update, Map<RealmObject, RealmObjectProxy> cache) {
        HandshakeRealm realmObject = (HandshakeRealm)realm.createObject(HandshakeRealm.class, (Object)newObject.getId());
        cache.put(newObject, (RealmObjectProxy)realmObject);
        realmObject.setMajor(newObject.getMajor());
        realmObject.setMinor(newObject.getMinor());
        realmObject.setRssi(newObject.getRssi());
        realmObject.setCheckinAt(newObject.getCheckinAt());
        realmObject.setCheckoutAt(newObject.getCheckoutAt());
        realmObject.setImpliedCheckout(newObject.isImpliedCheckout());
        realmObject.setCreatedAt(newObject.getCreatedAt());
        realmObject.setId(newObject.getId());
        return realmObject;
    }

    public static HandshakeRealm createDetachedCopy(HandshakeRealm realmObject, int currentDepth, int maxDepth, Map<RealmObject, RealmObjectProxy.CacheData<RealmObject>> cache) {
        HandshakeRealm standaloneObject;
        if (currentDepth > maxDepth || realmObject == null) {
            return null;
        }
        RealmObjectProxy.CacheData<RealmObject> cachedObject = cache.get(realmObject);
        if (cachedObject != null) {
            if (currentDepth >= cachedObject.minDepth) {
                return (HandshakeRealm)cachedObject.object;
            }
            standaloneObject = (HandshakeRealm)cachedObject.object;
            cachedObject.minDepth = currentDepth;
        } else {
            standaloneObject = new HandshakeRealm();
            cache.put(realmObject, (RealmObjectProxy.CacheData<RealmObject>)new RealmObjectProxy.CacheData(currentDepth, (RealmObject)standaloneObject));
        }
        standaloneObject.setMajor(realmObject.getMajor());
        standaloneObject.setMinor(realmObject.getMinor());
        standaloneObject.setRssi(realmObject.getRssi());
        standaloneObject.setCheckinAt(realmObject.getCheckinAt());
        standaloneObject.setCheckoutAt(realmObject.getCheckoutAt());
        standaloneObject.setImpliedCheckout(realmObject.isImpliedCheckout());
        standaloneObject.setCreatedAt(realmObject.getCreatedAt());
        standaloneObject.setId(realmObject.getId());
        return standaloneObject;
    }

    static HandshakeRealm update(Realm realm, HandshakeRealm realmObject, HandshakeRealm newObject, Map<RealmObject, RealmObjectProxy> cache) {
        realmObject.setMajor(newObject.getMajor());
        realmObject.setMinor(newObject.getMinor());
        realmObject.setRssi(newObject.getRssi());
        realmObject.setCheckinAt(newObject.getCheckinAt());
        realmObject.setCheckoutAt(newObject.getCheckoutAt());
        realmObject.setImpliedCheckout(newObject.isImpliedCheckout());
        realmObject.setCreatedAt(newObject.getCreatedAt());
        return realmObject;
    }

    public String toString() {
        if (!this.isValid()) {
            return "Invalid object";
        }
        StringBuilder stringBuilder = new StringBuilder("HandshakeRealm = [");
        stringBuilder.append("{major:");
        stringBuilder.append(this.getMajor());
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{minor:");
        stringBuilder.append(this.getMinor());
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{rssi:");
        stringBuilder.append(this.getRssi());
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{checkinAt:");
        stringBuilder.append(this.getCheckinAt());
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{checkoutAt:");
        stringBuilder.append(this.getCheckoutAt());
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{impliedCheckout:");
        stringBuilder.append(this.isImpliedCheckout());
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{createdAt:");
        stringBuilder.append(this.getCreatedAt());
        stringBuilder.append("}");
        stringBuilder.append(",");
        stringBuilder.append("{id:");
        stringBuilder.append(this.getId());
        stringBuilder.append("}");
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public int hashCode() {
        String realmName = this.realm.getPath();
        String tableName = this.row.getTable().getName();
        long rowIndex = this.row.getIndex();
        int result = 17;
        result = 31 * result + (realmName != null ? realmName.hashCode() : 0);
        result = 31 * result + (tableName != null ? tableName.hashCode() : 0);
        result = 31 * result + (int)(rowIndex ^ rowIndex >>> 32);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HandshakeRealmRealmProxy aHandshakeRealm = (HandshakeRealmRealmProxy)o;
        String path = this.realm.getPath();
        String otherPath = aHandshakeRealm.realm.getPath();
        if (path != null ? !path.equals(otherPath) : otherPath != null) {
            return false;
        }
        String tableName = this.row.getTable().getName();
        String otherTableName = aHandshakeRealm.row.getTable().getName();
        if (tableName != null ? !tableName.equals(otherTableName) : otherTableName != null) {
            return false;
        }
        return this.row.getIndex() == aHandshakeRealm.row.getIndex();
    }

    static {
        ArrayList<String> fieldNames = new ArrayList<String>();
        fieldNames.add("major");
        fieldNames.add("minor");
        fieldNames.add("rssi");
        fieldNames.add("checkinAt");
        fieldNames.add("checkoutAt");
        fieldNames.add("impliedCheckout");
        fieldNames.add("createdAt");
        fieldNames.add("id");
        FIELD_NAMES = Collections.unmodifiableList(fieldNames);
    }

    static final class HandshakeRealmColumnInfo
    extends ColumnInfo {
        public final long majorIndex;
        public final long minorIndex;
        public final long rssiIndex;
        public final long checkinAtIndex;
        public final long checkoutAtIndex;
        public final long impliedCheckoutIndex;
        public final long createdAtIndex;
        public final long idIndex;

        HandshakeRealmColumnInfo(String path, Table table) {
            HashMap<String, Long> indicesMap = new HashMap<String, Long>(8);
            this.majorIndex = this.getValidColumnIndex(path, table, "HandshakeRealm", "major");
            indicesMap.put("major", this.majorIndex);
            this.minorIndex = this.getValidColumnIndex(path, table, "HandshakeRealm", "minor");
            indicesMap.put("minor", this.minorIndex);
            this.rssiIndex = this.getValidColumnIndex(path, table, "HandshakeRealm", "rssi");
            indicesMap.put("rssi", this.rssiIndex);
            this.checkinAtIndex = this.getValidColumnIndex(path, table, "HandshakeRealm", "checkinAt");
            indicesMap.put("checkinAt", this.checkinAtIndex);
            this.checkoutAtIndex = this.getValidColumnIndex(path, table, "HandshakeRealm", "checkoutAt");
            indicesMap.put("checkoutAt", this.checkoutAtIndex);
            this.impliedCheckoutIndex = this.getValidColumnIndex(path, table, "HandshakeRealm", "impliedCheckout");
            indicesMap.put("impliedCheckout", this.impliedCheckoutIndex);
            this.createdAtIndex = this.getValidColumnIndex(path, table, "HandshakeRealm", "createdAt");
            indicesMap.put("createdAt", this.createdAtIndex);
            this.idIndex = this.getValidColumnIndex(path, table, "HandshakeRealm", "id");
            indicesMap.put("id", this.idIndex);
            this.setIndicesMap(indicesMap);
        }
    }
}

