/*
 * Decompiled with CFR 0.152.
 */
package io.proxsee.sdk.model.impl;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import io.proxsee.sdk.R;
import java.util.HashMap;

public class ProxSeeContext {
    public static final String TAG = ProxSeeContext.class.getSimpleName();
    public static final String DEFAULT_BASE_URL = "https://app.proxsee.io";
    public static final int DEFAULT_MAXIMUM_OFFLINE_HANDSHAKE = 500;
    public static final long DEFAULT_PROXSEE_ACTIVE_BEACONS_CACHE_TIME = 86400000L;
    private String apiKey;
    private final String apiURL;
    private final String version;
    private final int maxOfflineHandshake;
    private final long activeBeaconCacheTime;
    private Context context;
    SharedPreferences securePreference;
    SharedPreferences normalPreference;

    public ProxSeeContext(Context context, String string2, SharedPreferences sharedPreferences, SharedPreferences sharedPreferences2) {
        this.context = context;
        this.securePreference = sharedPreferences;
        this.normalPreference = sharedPreferences2;
        this.apiKey = string2;
        this.version = "3.0.3-Build48-master.91d4d70e574";
        this.apiURL = sharedPreferences2.getString(context.getString(R.string.proxsee_url_key), DEFAULT_BASE_URL);
        this.maxOfflineHandshake = sharedPreferences2.getInt(context.getString(R.string.proxsee_max_offline_handshake_key), 500);
        this.activeBeaconCacheTime = sharedPreferences2.getLong(context.getString(R.string.proxsee_active_beacons_cache_time_key), 86400000L);
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getApiURL() {
        return this.apiURL;
    }

    public int getMaxOfflineHandshake() {
        return this.maxOfflineHandshake;
    }

    public Context getApplicationContext() {
        return this.context;
    }

    public HashMap<String, String> getHeaders() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Authorization", "Bearer " + this.apiKey);
        hashMap.put("Content-Type", "application/json");
        hashMap.put("Accept", "application/json");
        hashMap.put("X-ProxSee-SDKPlatform", "android");
        hashMap.put("X-ProxSee-SDKVersion", this.version);
        return hashMap;
    }

    public void flushApiKey(String string2) {
        this.apiKey = string2;
    }

    public String getDeviceId() {
        return this.securePreference.getString(this.context.getString(R.string.proxsee_device_id_key), null);
    }

    public void saveDeviceId(String string2) {
        String string3 = this.context.getString(R.string.proxsee_device_id_key);
        if (this.securePreference.getString(string3, null) != null) {
            Log.d((String)TAG, (String)"Device ID already registered nothing saved");
        } else {
            Log.d((String)TAG, (String)("Saving Device ID " + string2));
            SharedPreferences.Editor editor = this.securePreference.edit();
            editor.putString(string3, string2);
            editor.commit();
        }
    }

    public String getFingerPrint() {
        return this.securePreference.getString(this.context.getString(R.string.proxsee_finger_print_key), null);
    }

    public void setFingerPrint(String string2) {
        SharedPreferences.Editor editor = this.securePreference.edit();
        editor.putString(this.context.getString(R.string.proxsee_finger_print_key), string2);
        editor.commit();
    }

    public boolean isSDKStarted() {
        return this.securePreference.getBoolean(this.context.getString(R.string.proxsee_sdk_state_key), true);
    }

    public void setEnabled(boolean bl) {
        SharedPreferences.Editor editor = this.securePreference.edit();
        editor.putBoolean(this.context.getString(R.string.proxsee_sdk_state_key), bl);
        editor.commit();
    }

    public String getMedataDataHash() {
        return this.securePreference.getString(this.context.getString(R.string.proxsee_metatadata_hash_key), null);
    }

    public void setMetaDataHash(String string2) {
        SharedPreferences.Editor editor = this.securePreference.edit();
        editor.putString(this.context.getString(R.string.proxsee_metatadata_hash_key), string2);
        editor.commit();
    }

    public long getActiveBeaconCacheTime() {
        return this.activeBeaconCacheTime;
    }
}

