/*
 * Decompiled with CFR 0.152.
 */
package io.proxsee.sdk.model.impl;

import io.proxsee.sdk.model.impl.DetectedBeacon;
import io.proxsee.sdk.model.impl.ProxSeeBeacon;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class DetectedBeaconsResult {
    private final Collection<DetectedBeacon> currentProxseeBeacons;
    private final Collection<DetectedBeacon> previousProxseeBeacons;
    private final Collection<DetectedBeacon> addedBeacons;
    private final Collection<DetectedBeacon> removedBeacons;
    private final Set<String> newTags;
    private final Set<String> oldTags;
    private final Date lastSeen;

    public DetectedBeaconsResult(Collection<DetectedBeacon> collection, Collection<DetectedBeacon> collection2) {
        this.currentProxseeBeacons = new HashSet<DetectedBeacon>(collection);
        this.previousProxseeBeacons = new HashSet<DetectedBeacon>(collection2);
        this.addedBeacons = this.substract(this.currentProxseeBeacons, this.previousProxseeBeacons);
        this.removedBeacons = this.substract(this.previousProxseeBeacons, this.currentProxseeBeacons);
        this.newTags = new HashSet<String>();
        this.oldTags = new HashSet<String>();
        for (ProxSeeBeacon proxSeeBeacon : this.currentProxseeBeacons) {
            this.newTags.addAll(Arrays.asList(proxSeeBeacon.getTags()));
        }
        for (ProxSeeBeacon proxSeeBeacon : this.previousProxseeBeacons) {
            this.oldTags.addAll(Arrays.asList(proxSeeBeacon.getTags()));
        }
        this.lastSeen = new Date();
    }

    private Collection<DetectedBeacon> substract(Collection<DetectedBeacon> collection, Collection<DetectedBeacon> collection2) {
        ArrayList<DetectedBeacon> arrayList = new ArrayList<DetectedBeacon>();
        arrayList.addAll(collection);
        arrayList.removeAll(collection2);
        return arrayList;
    }

    public Collection<DetectedBeacon> getCurrentProxseeBeacons() {
        return this.currentProxseeBeacons;
    }

    public Collection<DetectedBeacon> getPreviousProxseeBeacons() {
        return this.previousProxseeBeacons;
    }

    public Collection<DetectedBeacon> getAddedBeacons() {
        return this.addedBeacons;
    }

    public Collection<DetectedBeacon> getRemovedBeacons() {
        return this.removedBeacons;
    }

    public Set<String> getNewTags() {
        return this.newTags;
    }

    public Set<String> getOldTags() {
        return this.oldTags;
    }

    public boolean hasTagsChanged() {
        return !this.newTags.equals(this.oldTags);
    }

    public boolean hasBeaconsChanged() {
        return this.addedBeacons.size() > 0 || this.removedBeacons.size() > 0;
    }

    public Date getLastSeen() {
        return this.lastSeen;
    }
}

