package io.quantics.multitenant.tenantdetails;

/**
 * Provides core information about a tenant in a multi-tenant application.
 *
 * @see TenantDetailsService
 */
public interface TenantDetails {

    /**
     * Get the id of the tenant
     *
     * @return the id of the tenant
     */
    String getId();

    /**
     * Get the issuer of the tenant
     *
     * @return the issuer of the tenant
     */
    String getIssuer();

    /**
     * Get the JWK Set url of the tenant
     *
     * @return the JWK Set url of the tenant
     */
    String getJwkSetUrl();

}
