package io.quantics.multitenant.tenantdetails;

import java.util.Optional;

/**
 * Core interface which loads tenant-specific data.
 *
 * <p>
 * This service is used in multi-tenant applications for loading a tenant by a given issuer.
 * </p>
 *
 * @see TenantDetails
 */
public interface TenantDetailsService {

    /**
     * Get a tenant by issuer url.
     *
     * @param issuer the issuer url
     * @return the tenant wrapped in an {@link Optional}
     * or {@link Optional#empty()} if there is no tenant with the given issuer url
     */
    Optional<? extends TenantDetails> getByIssuer(String issuer);

}
