/*
 * Decompiled with CFR 0.152.
 */
package io.quantics.multitenant.oauth2.config;

import io.quantics.multitenant.TenantContext;
import io.quantics.multitenant.oauth2.config.HeaderCondition;
import io.quantics.multitenant.oauth2.config.JwtCondition;
import io.quantics.multitenant.oauth2.config.MultiTenantResourceServerProperties;
import io.quantics.multitenant.tenantdetails.TenantDetails;
import io.quantics.multitenant.tenantdetails.TenantDetailsService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.NonNull;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.server.resource.authentication.AbstractOAuth2TokenAuthenticationToken;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Configuration
@ConditionalOnMissingBean(value={WebMvcConfigurer.class})
public class MultiTenantResourceServerWebMvcConfiguration {
    private static final Log logger = LogFactory.getLog(WebMvcConfigurer.class);

    @Bean
    @Conditional(value={HeaderCondition.class})
    HandlerInterceptorAdapter multiTenantHeaderInterceptor(final MultiTenantResourceServerProperties properties) {
        return new HandlerInterceptorAdapter(){

            public boolean preHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler) {
                String tenantId = request.getHeader(properties.getHeader().getHeaderName());
                logger.debug((Object)("Set TenantContext: " + tenantId));
                TenantContext.setTenantId(tenantId);
                return true;
            }

            public void postHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler, ModelAndView modelAndView) {
                logger.debug((Object)("Clear TenantContext: " + TenantContext.getTenantId()));
                TenantContext.clear();
            }
        };
    }

    @Bean
    @Conditional(value={JwtCondition.class})
    HandlerInterceptorAdapter multiTenantJwtInterceptor(final TenantDetailsService tenantService) {
        return new HandlerInterceptorAdapter(){

            public boolean preHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler) {
                Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
                if (authentication instanceof AbstractOAuth2TokenAuthenticationToken) {
                    AbstractOAuth2TokenAuthenticationToken token = (AbstractOAuth2TokenAuthenticationToken)authentication;
                    String issuer = (String)token.getTokenAttributes().get("iss");
                    TenantDetails tenant = tenantService.getByIssuer(issuer).orElseThrow(() -> new IllegalArgumentException("Tenant not found for issuer: " + issuer));
                    logger.debug((Object)("Set TenantContext: " + tenant.getId()));
                    TenantContext.setTenantId(tenant.getId());
                }
                return true;
            }

            public void postHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler, ModelAndView modelAndView) {
                if (TenantContext.getTenantId() != null) {
                    logger.debug((Object)("Clear TenantContext: " + TenantContext.getTenantId()));
                    TenantContext.clear();
                }
            }
        };
    }

    @Bean
    @ConditionalOnBean(value={HandlerInterceptorAdapter.class})
    WebMvcConfigurer multiTenantWebMvcConfigurer() {
        return new WebMvcConfigurer(){
            @Autowired
            private HandlerInterceptorAdapter interceptor;

            public void addInterceptors(@NonNull InterceptorRegistry registry) {
                registry.addInterceptor((HandlerInterceptor)this.interceptor);
            }
        };
    }
}

