/*
 * Decompiled with CFR 0.152.
 */
package io.quantics.multitenant.oauth2.config;

import io.quantics.multitenant.oauth2.config.AbstractJwtGrantedAuthoritiesConverter;
import io.quantics.multitenant.oauth2.config.AuthoritiesConverterCondition;
import io.quantics.multitenant.oauth2.config.JwtCondition;
import io.quantics.multitenant.oauth2.config.MultiTenantResourceServerProperties;
import java.lang.reflect.InvocationTargetException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;

@Configuration
public class MultiTenantResourceServerWebSecurityConfiguration {
    @Bean
    @Conditional(value={JwtCondition.class, AuthoritiesConverterCondition.class})
    WebSecurityConfigurerAdapter multiTenantJwtAuthenticationConverterWebSecurity(final MultiTenantResourceServerProperties properties) {
        return new WebSecurityConfigurerAdapter(){

            protected void configure(HttpSecurity http) throws Exception {
                http.authorizeRequests(authorize -> ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)authorize.anyRequest()).authenticated());
                http.oauth2ResourceServer(oauth2 -> oauth2.jwt(jwt -> jwt.jwtAuthenticationConverter((Converter)this.jwtAuthenticationConverter())));
            }

            private JwtAuthenticationConverter jwtAuthenticationConverter() {
                JwtAuthenticationConverter jwtAuthenticationConverter = new JwtAuthenticationConverter();
                try {
                    Class<?> converterClass = Class.forName(properties.getJwt().getAuthoritiesConverter());
                    AbstractJwtGrantedAuthoritiesConverter converter = (AbstractJwtGrantedAuthoritiesConverter)converterClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    jwtAuthenticationConverter.setJwtGrantedAuthoritiesConverter((Converter)converter);
                    return jwtAuthenticationConverter;
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean(value={WebSecurityConfigurerAdapter.class})
    @ConditionalOnBean(value={JwtDecoder.class})
    WebSecurityConfigurerAdapter multiTenantJwtDecoderWebSecurity(final JwtDecoder multiTenantJwtDecoder) {
        return new WebSecurityConfigurerAdapter(){

            protected void configure(HttpSecurity http) throws Exception {
                http.authorizeRequests(authorize -> ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)authorize.anyRequest()).authenticated());
                http.oauth2ResourceServer(oauth2 -> oauth2.jwt(jwt -> jwt.decoder(multiTenantJwtDecoder)));
            }
        };
    }
}

