/*
 * Decompiled with CFR 0.152.
 */
package io.quantics.multitenant.oauth2.config;

import io.quantics.multitenant.tenantdetails.TenantDetails;
import io.quantics.multitenant.tenantdetails.TenantDetailsService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidatorResult;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtIssuerValidator;

public class MultiTenantJwtIssuerValidator
implements OAuth2TokenValidator<Jwt> {
    private final TenantDetailsService tenantService;
    private final Map<String, JwtIssuerValidator> validators = new ConcurrentHashMap<String, JwtIssuerValidator>();

    public MultiTenantJwtIssuerValidator(TenantDetailsService tenantService) {
        this.tenantService = tenantService;
    }

    public OAuth2TokenValidatorResult validate(Jwt token) {
        return this.validators.computeIfAbsent(this.toTenant(token), this::fromTenant).validate(token);
    }

    private String toTenant(Jwt jwt) {
        return jwt.getIssuer().toString();
    }

    private JwtIssuerValidator fromTenant(String issuer) {
        return this.tenantService.getByIssuer(issuer).map(TenantDetails::getIssuer).map(JwtIssuerValidator::new).orElseThrow(() -> new IllegalArgumentException("Unknown tenant"));
    }
}

