/*
 * Decompiled with CFR 0.152.
 */
package io.quantics.multitenant.oauth2.config;

import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import com.nimbusds.jwt.proc.JWTClaimsSetAwareJWSKeySelector;
import com.nimbusds.jwt.proc.JWTProcessor;
import io.quantics.multitenant.oauth2.config.JwtCondition;
import io.quantics.multitenant.oauth2.config.MultiTenantJWSKeySelector;
import io.quantics.multitenant.oauth2.config.MultiTenantJwtIssuerValidator;
import io.quantics.multitenant.tenantdetails.TenantDetailsService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.core.DelegatingOAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtValidators;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;

@Configuration
@Conditional(value={JwtCondition.class})
public class MultiTenantResourceServerJwtConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={JWTClaimsSetAwareJWSKeySelector.class})
    JWTClaimsSetAwareJWSKeySelector<SecurityContext> multiTenantJWSKeySelector(TenantDetailsService tenantService) {
        return new MultiTenantJWSKeySelector(tenantService);
    }

    @Bean
    @ConditionalOnMissingBean(value={JWTProcessor.class})
    JWTProcessor<SecurityContext> multiTenantJwtProcessor(JWTClaimsSetAwareJWSKeySelector<SecurityContext> multiTenantJWSKeySelector) {
        DefaultJWTProcessor jwtProcessor = new DefaultJWTProcessor();
        jwtProcessor.setJWTClaimsSetAwareJWSKeySelector(multiTenantJWSKeySelector);
        return jwtProcessor;
    }

    @Bean
    @ConditionalOnMissingBean(value={OAuth2TokenValidator.class})
    OAuth2TokenValidator<Jwt> multiTenantJwtIssuerValidator(TenantDetailsService tenantService) {
        return new MultiTenantJwtIssuerValidator(tenantService);
    }

    @Bean
    @ConditionalOnMissingBean(value={JwtDecoder.class})
    JwtDecoder multiTenantJwtDecoder(JWTProcessor<SecurityContext> multiTenantJwtProcessor, OAuth2TokenValidator<Jwt> multiTenantJwtIssuerValidator) {
        NimbusJwtDecoder decoder = new NimbusJwtDecoder(multiTenantJwtProcessor);
        decoder.setJwtValidator((OAuth2TokenValidator)new DelegatingOAuth2TokenValidator(new OAuth2TokenValidator[]{JwtValidators.createDefault(), multiTenantJwtIssuerValidator}));
        return decoder;
    }
}

